/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.ga4gh.vrs.v1.CopyNumber;
import org.ga4gh.vrs.v1.DerivedSequenceExpression;
import org.ga4gh.vrs.v1.Number;
import org.ga4gh.vrs.v1.SequenceInterval;
import org.ga4gh.vrs.v1.SequenceLocation;
import org.ga4gh.vrs.v1.Variation;
import org.phenopackets.phenopackettools.core.PhenopacketToolsRuntimeException;

public class CopyNumberBuilder {
    private final CopyNumber.Builder builder = CopyNumber.newBuilder();

    private CopyNumberBuilder() {
    }

    public CopyNumberBuilder copyNumberId(String id) {
        this.builder.setId(id);
        return this;
    }

    public CopyNumberBuilder alleleLocation(String contig, int interbaseStartPos, int interbaseEndPos) {
        this.builder.setDerivedSequenceExpression(DerivedSequenceExpression.newBuilder().setLocation(SequenceLocation.newBuilder().setSequenceId(contig).setSequenceInterval(SequenceInterval.newBuilder().setStartNumber(Number.newBuilder().setValue((long)interbaseStartPos)).setEndNumber(Number.newBuilder().setValue((long)interbaseEndPos)))));
        return this;
    }

    public CopyNumber build() {
        return this.builder.build();
    }

    public CopyNumberBuilder oneCopy() {
        this.builder.setNumber(Number.newBuilder().setValue(1L));
        return this;
    }

    public CopyNumberBuilder twoCopies() {
        this.builder.setNumber(Number.newBuilder().setValue(2L));
        return this;
    }

    public CopyNumberBuilder threeCopies() {
        this.builder.setNumber(Number.newBuilder().setValue(3L));
        return this;
    }

    public CopyNumberBuilder nCopies(int n) {
        if (n < 0) {
            throw new PhenopacketToolsRuntimeException("Negative copy numbers are not allowed");
        }
        this.builder.setNumber(Number.newBuilder().setValue((long)n));
        return this;
    }

    public Variation buildVariation() {
        return Variation.newBuilder().setCopyNumber(this.builder).build();
    }

    public static CopyNumberBuilder builder() {
        return new CopyNumberBuilder();
    }
}

