/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.phenopackets.phenopackettools.builder.builders.ExternalReferenceBuilder;
import org.phenopackets.phenopackettools.builder.builders.OntologyClassBuilder;
import org.phenopackets.schema.v2.core.Evidence;
import org.phenopackets.schema.v2.core.ExternalReference;
import org.phenopackets.schema.v2.core.OntologyClass;

public class EvidenceBuilder {
    private final Evidence.Builder builder;

    private EvidenceBuilder(OntologyClass evidenceCode) {
        this.builder = Evidence.newBuilder().setEvidenceCode(evidenceCode);
    }

    public static Evidence of(String id, String label) {
        OntologyClass evidenceCode = OntologyClassBuilder.ontologyClass(id, label);
        return new EvidenceBuilder(evidenceCode).build();
    }

    public static Evidence of(OntologyClass evidenceCode) {
        return new EvidenceBuilder(evidenceCode).build();
    }

    public static Evidence of(OntologyClass evidenceCode, ExternalReference externalReference) {
        return new EvidenceBuilder(evidenceCode).reference(externalReference).build();
    }

    public static EvidenceBuilder builder(String id, String label) {
        OntologyClass evidenceCode = OntologyClassBuilder.ontologyClass(id, label);
        return new EvidenceBuilder(evidenceCode);
    }

    public static EvidenceBuilder builder(OntologyClass evidenceCode) {
        return new EvidenceBuilder(evidenceCode);
    }

    public static Evidence authorStatementEvidence(String pmid, String title) {
        String id = "ECO:0000033";
        String label = "author statement supported by traceable reference";
        OntologyClass evidenceCode = OntologyClassBuilder.ontologyClass(id, label);
        ExternalReference externalReference = ExternalReferenceBuilder.of(pmid, title);
        return EvidenceBuilder.of(evidenceCode, externalReference);
    }

    public EvidenceBuilder reference(ExternalReference externalReference) {
        this.builder.setReference(externalReference);
        return this;
    }

    public Evidence build() {
        return this.builder.build();
    }
}

