/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import java.util.List;
import org.ga4gh.vrsatile.v1.GeneDescriptor;

public class GeneDescriptorBuilder {
    private final GeneDescriptor.Builder builder;

    private GeneDescriptorBuilder(String valueId, String symbol) {
        this.builder = GeneDescriptor.newBuilder().setValueId(valueId).setSymbol(symbol);
    }

    public static GeneDescriptor of(String valueId, String symbol) {
        return GeneDescriptor.newBuilder().setValueId(valueId).setSymbol(symbol).build();
    }

    public static GeneDescriptorBuilder builder(String valueId, String symbol) {
        return new GeneDescriptorBuilder(valueId, symbol);
    }

    public GeneDescriptorBuilder description(String desc) {
        this.builder.setDescription(desc);
        return this;
    }

    public GeneDescriptorBuilder addAlternateId(String altId) {
        this.builder.addAlternateIds(altId);
        return this;
    }

    public GeneDescriptorBuilder addAllAlternateIds(List<String> altIds) {
        this.builder.addAllAlternateIds(altIds);
        return this;
    }

    public GeneDescriptorBuilder addXref(String xref) {
        this.builder.addXrefs(xref);
        return this;
    }

    public GeneDescriptorBuilder addAllXrefs(List<String> xrefs) {
        this.builder.addAllXrefs(xrefs);
        return this;
    }

    public GeneDescriptorBuilder addAlternateSymbol(String altSymbol) {
        this.builder.addAlternateSymbols(altSymbol);
        return this;
    }

    public GeneDescriptorBuilder addAllAlternateSymbols(List<String> altSymbols) {
        this.builder.addAllAlternateSymbols(altSymbols);
        return this;
    }

    public GeneDescriptor build() {
        return this.builder.build();
    }
}

