/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.ga4gh.vrsatile.v1.GeneDescriptor;
import org.phenopackets.phenopackettools.builder.builders.VariantInterpretationBuilder;
import org.phenopackets.schema.v2.core.GenomicInterpretation;
import org.phenopackets.schema.v2.core.VariantInterpretation;

public class GenomicInterpretationBuilder {
    private final GenomicInterpretation.Builder builder;

    private GenomicInterpretationBuilder(String subjectOrBiosampleId) {
        this.builder = GenomicInterpretation.newBuilder().setSubjectOrBiosampleId(subjectOrBiosampleId);
    }

    public static GenomicInterpretationBuilder builder(String subjectOrBiosampleId) {
        return new GenomicInterpretationBuilder(subjectOrBiosampleId);
    }

    public GenomicInterpretationBuilder rejected() {
        this.builder.setInterpretationStatus(GenomicInterpretation.InterpretationStatus.REJECTED);
        return this;
    }

    public GenomicInterpretationBuilder candidate() {
        this.builder.setInterpretationStatus(GenomicInterpretation.InterpretationStatus.CANDIDATE);
        return this;
    }

    public GenomicInterpretationBuilder contributory() {
        this.builder.setInterpretationStatus(GenomicInterpretation.InterpretationStatus.CONTRIBUTORY);
        return this;
    }

    public GenomicInterpretationBuilder causative() {
        this.builder.setInterpretationStatus(GenomicInterpretation.InterpretationStatus.CAUSATIVE);
        return this;
    }

    public GenomicInterpretationBuilder unknown() {
        this.builder.setInterpretationStatus(GenomicInterpretation.InterpretationStatus.UNKNOWN_STATUS);
        return this;
    }

    public GenomicInterpretationBuilder geneDescriptor(GeneDescriptor geneDescriptor) {
        this.builder.setGene(geneDescriptor);
        return this;
    }

    public GenomicInterpretationBuilder variantInterpretation(VariantInterpretation variantInterpretation) {
        this.builder.setVariantInterpretation(variantInterpretation);
        return this;
    }

    public GenomicInterpretationBuilder variantInterpretation(VariantInterpretationBuilder vibuilder) {
        this.builder.setVariantInterpretation(vibuilder.build());
        return this;
    }

    public GenomicInterpretation build() {
        return this.builder.build();
    }
}

