/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import com.google.protobuf.Timestamp;
import java.time.LocalDate;
import java.util.List;
import org.phenopackets.phenopackettools.builder.builders.OntologyClassBuilder;
import org.phenopackets.phenopackettools.builder.builders.TimeElements;
import org.phenopackets.phenopackettools.builder.builders.TimestampBuilder;
import org.phenopackets.schema.v2.core.Individual;
import org.phenopackets.schema.v2.core.KaryotypicSex;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.Sex;
import org.phenopackets.schema.v2.core.TimeElement;
import org.phenopackets.schema.v2.core.VitalStatus;

public class IndividualBuilder {
    private static final OntologyClass HOMO_SAPIENS = OntologyClassBuilder.ontologyClass("NCBITaxon:9606", "Homo sapiens");
    private final Individual.Builder builder;

    private IndividualBuilder(String id) {
        this.builder = Individual.newBuilder().setId(id);
    }

    public static Individual of(String id) {
        return Individual.newBuilder().setId(id).build();
    }

    public static IndividualBuilder builder(String id) {
        return new IndividualBuilder(id);
    }

    public IndividualBuilder addAlternateId(String altId) {
        this.builder.addAlternateIds(altId);
        return this;
    }

    public IndividualBuilder addAllAlternateIds(List<String> altIdList) {
        this.builder.addAllAlternateIds(altIdList);
        return this;
    }

    public IndividualBuilder dateOfBirth(LocalDate localDate) {
        Timestamp timestamp = TimestampBuilder.timestamp(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        this.builder.setDateOfBirth(timestamp);
        return this;
    }

    public IndividualBuilder dateOfBirth(String dobirth) {
        Timestamp dob = TimestampBuilder.fromISO8601(dobirth);
        this.builder.setDateOfBirth(dob);
        return this;
    }

    public IndividualBuilder timestampAtLastEncounter(String timestamp) {
        TimeElement t = TimeElements.timestamp(timestamp);
        this.builder.setTimeAtLastEncounter(t);
        return this;
    }

    public IndividualBuilder ageAtLastEncounter(TimeElement timeElement) {
        this.builder.setTimeAtLastEncounter(timeElement);
        return this;
    }

    public IndividualBuilder ageAtLastEncounter(String iso8601) {
        TimeElement t = TimeElements.age(iso8601);
        this.builder.setTimeAtLastEncounter(t);
        return this;
    }

    public IndividualBuilder alive() {
        VitalStatus status = VitalStatus.newBuilder().setStatus(VitalStatus.Status.ALIVE).build();
        this.builder.setVitalStatus(status);
        return this;
    }

    public IndividualBuilder deceased() {
        VitalStatus status = VitalStatus.newBuilder().setStatus(VitalStatus.Status.DECEASED).build();
        this.builder.setVitalStatus(status);
        return this;
    }

    public IndividualBuilder vitalStatus(VitalStatus status) {
        this.builder.setVitalStatus(status);
        return this;
    }

    public IndividualBuilder male() {
        this.builder.setSex(Sex.MALE);
        return this;
    }

    public IndividualBuilder female() {
        this.builder.setSex(Sex.FEMALE);
        return this;
    }

    public IndividualBuilder unknownSex() {
        this.builder.setSex(Sex.UNKNOWN_SEX);
        return this;
    }

    public IndividualBuilder otherSex() {
        this.builder.setSex(Sex.OTHER_SEX);
        return this;
    }

    public IndividualBuilder XX() {
        this.builder.setKaryotypicSex(KaryotypicSex.XX);
        return this;
    }

    public IndividualBuilder XY() {
        this.builder.setKaryotypicSex(KaryotypicSex.XY);
        return this;
    }

    public IndividualBuilder XO() {
        this.builder.setKaryotypicSex(KaryotypicSex.XO);
        return this;
    }

    public IndividualBuilder XXY() {
        this.builder.setKaryotypicSex(KaryotypicSex.XXY);
        return this;
    }

    public IndividualBuilder XXX() {
        this.builder.setKaryotypicSex(KaryotypicSex.XXX);
        return this;
    }

    public IndividualBuilder XXYY() {
        this.builder.setKaryotypicSex(KaryotypicSex.XXYY);
        return this;
    }

    public IndividualBuilder XXXY() {
        this.builder.setKaryotypicSex(KaryotypicSex.XXXY);
        return this;
    }

    public IndividualBuilder XXXX() {
        this.builder.setKaryotypicSex(KaryotypicSex.XXXX);
        return this;
    }

    public IndividualBuilder taxonomy(OntologyClass taxon) {
        this.builder.setTaxonomy(taxon);
        return this;
    }

    public IndividualBuilder homoSapiens() {
        this.builder.setTaxonomy(HOMO_SAPIENS);
        return this;
    }

    public Individual build() {
        return this.builder.build();
    }
}

