/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.phenopackets.schema.v2.core.Diagnosis;
import org.phenopackets.schema.v2.core.Interpretation;

public class InterpretationBuilder {
    private final Interpretation.Builder builder;

    private InterpretationBuilder(String interpretationId, Interpretation.ProgressStatus status) {
        this.builder = Interpretation.newBuilder().setId(interpretationId).setProgressStatus(status);
    }

    public static Interpretation of(String interpretationId, Interpretation.ProgressStatus status, Diagnosis diagnosis, String summary) {
        return Interpretation.newBuilder().setId(interpretationId).setProgressStatus(status).setDiagnosis(diagnosis).setSummary(summary).build();
    }

    public static InterpretationBuilder builder(String interpretationId) {
        return new InterpretationBuilder(interpretationId, Interpretation.ProgressStatus.UNKNOWN_PROGRESS);
    }

    public InterpretationBuilder summary(String summary) {
        this.builder.setSummary(summary);
        return this;
    }

    public Interpretation inProgress() {
        this.builder.setProgressStatus(Interpretation.ProgressStatus.IN_PROGRESS);
        return this.builder.build();
    }

    public Interpretation completed(Diagnosis diagnosis) {
        this.builder.setProgressStatus(Interpretation.ProgressStatus.COMPLETED);
        this.builder.setDiagnosis(diagnosis);
        return this.builder.build();
    }

    public Interpretation solved(Diagnosis diagnosis) {
        this.builder.setProgressStatus(Interpretation.ProgressStatus.SOLVED);
        this.builder.setDiagnosis(diagnosis);
        return this.builder.build();
    }

    public Interpretation unsolved() {
        this.builder.setProgressStatus(Interpretation.ProgressStatus.UNSOLVED);
        this.builder.clearDiagnosis();
        return this.builder.build();
    }
}

