/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import java.util.List;
import org.phenopackets.phenopackettools.builder.builders.DoseIntervalBuilder;
import org.phenopackets.phenopackettools.builder.builders.TreatmentBuilder;
import org.phenopackets.schema.v2.core.DoseInterval;
import org.phenopackets.schema.v2.core.MedicalAction;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.Procedure;
import org.phenopackets.schema.v2.core.Quantity;
import org.phenopackets.schema.v2.core.RadiationTherapy;
import org.phenopackets.schema.v2.core.TherapeuticRegimen;
import org.phenopackets.schema.v2.core.TimeInterval;
import org.phenopackets.schema.v2.core.Treatment;

public class MedicalActionBuilder {
    private final MedicalAction.Builder builder;

    private MedicalActionBuilder(Procedure procedure) {
        this.builder = MedicalAction.newBuilder().setProcedure(procedure);
    }

    private MedicalActionBuilder(Treatment treatment) {
        this.builder = MedicalAction.newBuilder().setTreatment(treatment);
    }

    private MedicalActionBuilder(RadiationTherapy rxTherapy) {
        this.builder = MedicalAction.newBuilder().setRadiationTherapy(rxTherapy);
    }

    private MedicalActionBuilder(TherapeuticRegimen regimen) {
        this.builder = MedicalAction.newBuilder().setTherapeuticRegimen(regimen);
    }

    public static MedicalAction procedure(Procedure procedure) {
        return MedicalAction.newBuilder().setProcedure(procedure).build();
    }

    public static MedicalAction treatment(Treatment treatment) {
        return MedicalAction.newBuilder().setTreatment(treatment).build();
    }

    public static MedicalAction radiationTherapy(RadiationTherapy rxTherapy) {
        return MedicalAction.newBuilder().setRadiationTherapy(rxTherapy).build();
    }

    public static MedicalAction therapeuticRegimen(TherapeuticRegimen regimen) {
        return MedicalAction.newBuilder().setTherapeuticRegimen(regimen).build();
    }

    public static MedicalActionBuilder builder(Procedure procedure) {
        return new MedicalActionBuilder(procedure);
    }

    public static MedicalActionBuilder builder(Treatment treatment) {
        return new MedicalActionBuilder(treatment);
    }

    public static MedicalActionBuilder builder(RadiationTherapy rxTherapy) {
        return new MedicalActionBuilder(rxTherapy);
    }

    public static MedicalActionBuilder oralAdministration(OntologyClass agent, Quantity quantity, OntologyClass scheduleFrequency, TimeInterval interval) {
        DoseInterval doseInterval = DoseIntervalBuilder.of(quantity, scheduleFrequency, interval);
        Treatment tb = TreatmentBuilder.oralAdministration(agent).addDoseInterval(doseInterval).build();
        return new MedicalActionBuilder(tb);
    }

    public static MedicalActionBuilder intravenousAdministration(OntologyClass agent, Quantity quantity, OntologyClass scheduleFrequency, TimeInterval interval) {
        DoseInterval doseInterval = DoseIntervalBuilder.of(quantity, scheduleFrequency, interval);
        Treatment tb = TreatmentBuilder.intravenousAdministration(agent).addDoseInterval(doseInterval).build();
        return new MedicalActionBuilder(tb);
    }

    public static MedicalActionBuilder builder(TherapeuticRegimen regimen) {
        return new MedicalActionBuilder(regimen);
    }

    public MedicalActionBuilder treatmentTarget(OntologyClass target) {
        this.builder.setTreatmentTarget(target);
        return this;
    }

    public MedicalActionBuilder treatmentIntent(OntologyClass intent) {
        this.builder.setTreatmentIntent(intent);
        return this;
    }

    public MedicalActionBuilder responseToTreatment(OntologyClass response) {
        this.builder.setResponseToTreatment(response);
        return this;
    }

    public MedicalActionBuilder addAdverseEvent(OntologyClass event) {
        this.builder.addAdverseEvents(event);
        return this;
    }

    public MedicalActionBuilder allAdverseEvents(List<OntologyClass> events) {
        this.builder.addAllAdverseEvents(events);
        return this;
    }

    public MedicalActionBuilder treatmentTerminationReason(OntologyClass reason) {
        this.builder.setTreatmentTerminationReason(reason);
        return this;
    }

    public MedicalAction build() {
        return this.builder.build();
    }
}

