/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import org.phenopackets.phenopackettools.builder.builders.TimestampBuilder;
import org.phenopackets.schema.v2.core.ExternalReference;
import org.phenopackets.schema.v2.core.MetaData;
import org.phenopackets.schema.v2.core.Resource;
import org.phenopackets.schema.v2.core.Update;

public class MetaDataBuilder {
    private static final String SCHEMA_VERSION = "2.0.0";
    private final MetaData.Builder builder;

    private MetaDataBuilder(String created, String createdBy) {
        this.builder = MetaData.newBuilder().setCreated(TimestampBuilder.fromISO8601(created)).setCreatedBy(createdBy).setPhenopacketSchemaVersion(SCHEMA_VERSION);
    }

    private MetaDataBuilder(Timestamp createdTimeStamp, String createdBy) {
        this.builder = MetaData.newBuilder().setCreated(createdTimeStamp).setCreatedBy(createdBy).setPhenopacketSchemaVersion(SCHEMA_VERSION);
    }

    public static MetaDataBuilder builder(String created, String createdBy) {
        return new MetaDataBuilder(created, createdBy);
    }

    public static MetaDataBuilder builder(Timestamp createdTimeStamp, String createdBy) {
        return new MetaDataBuilder(createdTimeStamp, createdBy);
    }

    public static MetaDataBuilder builder(String createdBy) {
        Instant time = Instant.now();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build();
        return new MetaDataBuilder(timestamp, createdBy);
    }

    public MetaDataBuilder submittedBy(String submitter) {
        this.builder.setSubmittedBy(submitter);
        return this;
    }

    public MetaDataBuilder addResource(Resource r) {
        this.builder.addResources(r);
        return this;
    }

    public MetaDataBuilder addUpdate(Update u) {
        this.builder.addUpdates(u);
        return this;
    }

    public MetaDataBuilder addExternalReference(ExternalReference er) {
        this.builder.addExternalReferences(er);
        return this;
    }

    public MetaDataBuilder addExternalReference(String id, String description) {
        ExternalReference er = ExternalReference.newBuilder().setId(id).setDescription(description).build();
        return this.addExternalReference(er);
    }

    public MetaData build() {
        return this.builder.build();
    }
}

