/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.phenopackets.schema.v2.core.Pedigree;
import org.phenopackets.schema.v2.core.Sex;

public class PersonBuilder {
    private static final String parental_id_not_available = "0";
    private final Pedigree.Person.Builder builder = Pedigree.Person.newBuilder();

    private PersonBuilder(String familyId, String individualId, String paternalId, String maternalId) {
        this.builder.setFamilyId(familyId);
        this.builder.setIndividualId(individualId);
        this.builder.setPaternalId(paternalId);
        this.builder.setMaternalId(maternalId);
    }

    public PersonBuilder male() {
        this.builder.setSex(Sex.MALE);
        return this;
    }

    public PersonBuilder female() {
        this.builder.setSex(Sex.FEMALE);
        return this;
    }

    public PersonBuilder unknownSex() {
        this.builder.setSex(Sex.UNKNOWN_SEX);
        return this;
    }

    public PersonBuilder affected() {
        this.builder.setAffectedStatus(Pedigree.Person.AffectedStatus.AFFECTED);
        return this;
    }

    public PersonBuilder unaffected() {
        this.builder.setAffectedStatus(Pedigree.Person.AffectedStatus.UNAFFECTED);
        return this;
    }

    public PersonBuilder missing() {
        this.builder.setAffectedStatus(Pedigree.Person.AffectedStatus.MISSING);
        return this;
    }

    public static PersonBuilder builder(String familyId, String individualId, String paternalId, String maternalId) {
        return new PersonBuilder(familyId, individualId, paternalId, maternalId);
    }

    public static PersonBuilder builderWithParentsAsFounders(String familyId, String individualId) {
        return new PersonBuilder(familyId, individualId, parental_id_not_available, parental_id_not_available);
    }

    public Pedigree.Person build() {
        return this.builder.build();
    }
}

