/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import java.util.List;
import org.phenopackets.phenopackettools.builder.builders.OntologyClassBuilder;
import org.phenopackets.phenopackettools.builder.builders.TimeElements;
import org.phenopackets.schema.v2.core.Evidence;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.PhenotypicFeature;
import org.phenopackets.schema.v2.core.TimeElement;

public class PhenotypicFeatureBuilder {
    private final PhenotypicFeature.Builder builder;

    private PhenotypicFeatureBuilder(OntologyClass feature) {
        this.builder = PhenotypicFeature.newBuilder().setType(feature);
    }

    public static PhenotypicFeature of(OntologyClass feature) {
        return PhenotypicFeature.newBuilder().setType(feature).build();
    }

    public static PhenotypicFeature of(String id, String label) {
        OntologyClass ontologyClass = OntologyClassBuilder.ontologyClass(id, label);
        return PhenotypicFeatureBuilder.of(ontologyClass);
    }

    public static PhenotypicFeatureBuilder builder(OntologyClass feature) {
        return new PhenotypicFeatureBuilder(feature);
    }

    public static PhenotypicFeatureBuilder builder(String id, String label) {
        OntologyClass ontologyClass = OntologyClassBuilder.ontologyClass(id, label);
        return PhenotypicFeatureBuilder.builder(ontologyClass);
    }

    public PhenotypicFeatureBuilder onset(TimeElement time) {
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder iso8601onset(String iso8601) {
        this.builder.setOnset(TimeElements.age(iso8601));
        return this;
    }

    public PhenotypicFeatureBuilder congenitalOnset() {
        TimeElement time = TimeElements.congenitalOnset();
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder embryonalOnset() {
        TimeElement time = TimeElements.embryonalOnset();
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder fetalOnset() {
        TimeElement time = TimeElements.fetalOnset();
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder infantileOnset() {
        TimeElement time = TimeElements.infantileOnset();
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder childhoodOnset() {
        TimeElement time = TimeElements.childhoodOnset();
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder adultOnset() {
        TimeElement time = TimeElements.adultOnset();
        this.builder.setOnset(time);
        return this;
    }

    public PhenotypicFeatureBuilder resolution(TimeElement time) {
        this.builder.setResolution(time);
        return this;
    }

    public PhenotypicFeatureBuilder severity(String id, String label) {
        OntologyClass severity = OntologyClassBuilder.ontologyClass(id, label);
        return this.severity(severity);
    }

    public PhenotypicFeatureBuilder severity(OntologyClass severity) {
        this.builder.setSeverity(severity);
        return this;
    }

    public PhenotypicFeatureBuilder excluded() {
        this.builder.setExcluded(true);
        return this;
    }

    public PhenotypicFeatureBuilder addEvidence(Evidence evidence) {
        this.builder.addEvidence(evidence);
        return this;
    }

    public PhenotypicFeatureBuilder addAllEvidence(List<Evidence> evidenceList) {
        this.builder.addAllEvidence(evidenceList);
        return this;
    }

    public PhenotypicFeatureBuilder addModifier(OntologyClass modifier) {
        this.builder.addModifiers(modifier);
        return this;
    }

    public PhenotypicFeatureBuilder addAllModifiers(List<OntologyClass> modifiers) {
        this.builder.addAllModifiers(modifiers);
        return this;
    }

    public PhenotypicFeatureBuilder description(String text) {
        this.builder.setDescription(text);
        return this;
    }

    public PhenotypicFeature build() {
        return this.builder.build();
    }
}

