/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.phenopackets.phenopackettools.builder.builders.OntologyClassBuilder;
import org.phenopackets.phenopackettools.builder.builders.ReferenceRangeBuilder;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.Quantity;
import org.phenopackets.schema.v2.core.ReferenceRange;

public class QuantityBuilder {
    private final Quantity.Builder builder;

    private QuantityBuilder(OntologyClass unit, double value) {
        this.builder = Quantity.newBuilder().setUnit(unit).setValue(value);
    }

    public static Quantity of(OntologyClass unit, double value) {
        return Quantity.newBuilder().setUnit(unit).setValue(value).build();
    }

    public static Quantity of(String id, String label, double value) {
        return QuantityBuilder.of(OntologyClassBuilder.ontologyClass(id, label), value);
    }

    public static Quantity of(String id, String label, double value, ReferenceRange ref) {
        return QuantityBuilder.of(OntologyClassBuilder.ontologyClass(id, label), value);
    }

    public static Quantity of(OntologyClass unit, double value, ReferenceRange ref) {
        return Quantity.newBuilder().setUnit(unit).setValue(value).setReferenceRange(ref).build();
    }

    public static QuantityBuilder builder(OntologyClass unit, double value) {
        return new QuantityBuilder(unit, value);
    }

    public static QuantityBuilder builder(String id, String label, double value) {
        return new QuantityBuilder(OntologyClassBuilder.ontologyClass(id, label), value);
    }

    public QuantityBuilder referenceRange(ReferenceRange range) {
        this.builder.setReferenceRange(range);
        return this;
    }

    public QuantityBuilder referenceRange(OntologyClass unit, double low, double high) {
        ReferenceRange range = ReferenceRangeBuilder.of(unit, low, high);
        this.builder.setReferenceRange(range);
        return this;
    }

    public QuantityBuilder referenceRange(String id, String label, double low, double high) {
        ReferenceRange range = ReferenceRangeBuilder.of(id, label, low, high);
        this.builder.setReferenceRange(range);
        return this;
    }

    public Quantity build() {
        return this.builder.build();
    }
}

