/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;

public class TimestampBuilder {
    private final Timestamp.Builder builder;

    public TimestampBuilder(long seconds) {
        this.builder = Timestamp.newBuilder().setSeconds(seconds);
    }

    public Timestamp build() {
        return this.builder.build();
    }

    public static Timestamp seconds(long seconds) {
        return Timestamp.newBuilder().setSeconds(seconds).build();
    }

    public static Timestamp now() {
        Instant instant = Instant.now();
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static Timestamp timestamp(int y, int m, int d) {
        LocalDateTime timeNow = LocalDate.of(y, m, d).atTime(0, 0);
        return Timestamp.newBuilder().setSeconds(timeNow.toEpochSecond(ZoneOffset.UTC)).build();
    }

    public static Timestamp timestamp(int y, int m, int d, int h, int min) {
        LocalDateTime timeNow = LocalDate.of(y, m, d).atTime(h, min);
        return Timestamp.newBuilder().setSeconds(timeNow.toEpochSecond(ZoneOffset.UTC)).build();
    }

    public static Timestamp fromInstant(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static Timestamp fromISO8601LocalDate(String date) {
        LocalDate localDate = LocalDate.parse(date);
        return Timestamp.newBuilder().setSeconds(localDate.toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC)).build();
    }

    public static Timestamp fromISO8601(String time) {
        try {
            Instant instant = Instant.parse(time);
            return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        }
        catch (DateTimeParseException dateTimeParseException) {
            return TimestampBuilder.fromISO8601LocalDate(time);
        }
    }
}

