/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import java.util.List;
import org.phenopackets.phenopackettools.builder.builders.OntologyClassBuilder;
import org.phenopackets.phenopackettools.builder.constants.MedicalActions;
import org.phenopackets.schema.v2.core.DoseInterval;
import org.phenopackets.schema.v2.core.DrugType;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.Quantity;
import org.phenopackets.schema.v2.core.Treatment;

public class TreatmentBuilder {
    private final Treatment.Builder builder;

    private TreatmentBuilder(OntologyClass agent) {
        this.builder = Treatment.newBuilder().setAgent(agent);
    }

    public static Treatment of(OntologyClass agent) {
        return Treatment.newBuilder().setAgent(agent).build();
    }

    public static Treatment of(String agentId, String agentLabel) {
        return TreatmentBuilder.of(OntologyClassBuilder.ontologyClass(agentId, agentLabel));
    }

    public static TreatmentBuilder builder(OntologyClass agent) {
        return new TreatmentBuilder(agent);
    }

    public static TreatmentBuilder oralAdministration(OntologyClass agent) {
        return TreatmentBuilder.builder(agent).routeOfAdministration(MedicalActions.oralAdministration());
    }

    public static TreatmentBuilder intravenousAdministration(OntologyClass agent) {
        return TreatmentBuilder.builder(agent).routeOfAdministration(MedicalActions.intravenousAdministration());
    }

    public static TreatmentBuilder builder(String id, String label) {
        return new TreatmentBuilder(OntologyClassBuilder.ontologyClass(id, label));
    }

    public TreatmentBuilder routeOfAdministration(OntologyClass route) {
        this.builder.setRouteOfAdministration(route);
        return this;
    }

    public TreatmentBuilder addDoseInterval(DoseInterval interval) {
        this.builder.addDoseIntervals(interval);
        return this;
    }

    public TreatmentBuilder addAllDoseIntervals(List<DoseInterval> intervals) {
        this.builder.addAllDoseIntervals(intervals);
        return this;
    }

    public TreatmentBuilder prescription() {
        this.builder.setDrugType(DrugType.PRESCRIPTION);
        return this;
    }

    public TreatmentBuilder ehrMedicationList() {
        this.builder.setDrugType(DrugType.EHR_MEDICATION_LIST);
        return this;
    }

    public TreatmentBuilder procedureRelated() {
        this.builder.setDrugType(DrugType.ADMINISTRATION_RELATED_TO_PROCEDURE);
        return this;
    }

    public TreatmentBuilder cumulativeDose(Quantity quantity) {
        this.builder.setCumulativeDose(quantity);
        return this;
    }

    public Treatment build() {
        return this.builder.build();
    }
}

