/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.phenopackets.phenopackettools.builder.builders.OntologyClassBuilder;
import org.phenopackets.phenopackettools.builder.builders.QuantityBuilder;
import org.phenopackets.phenopackettools.builder.builders.ReferenceRangeBuilder;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.Quantity;
import org.phenopackets.schema.v2.core.ReferenceRange;
import org.phenopackets.schema.v2.core.Value;

public class ValueBuilder {
    private ValueBuilder() {
    }

    public static Value of(String id, String label) {
        OntologyClass ontologyClass = OntologyClassBuilder.ontologyClass(id, label);
        return ValueBuilder.of(ontologyClass);
    }

    public static Value of(OntologyClass ontologyClass) {
        return Value.newBuilder().setOntologyClass(ontologyClass).build();
    }

    public static Value of(Quantity quantity) {
        return Value.newBuilder().setQuantity(quantity).build();
    }

    public static Value of(String id, String label, double value) {
        Quantity quantity = QuantityBuilder.of(id, label, value);
        return ValueBuilder.of(quantity);
    }

    public static Value of(OntologyClass assay, double value) {
        Quantity quantity = QuantityBuilder.of(assay, value);
        return ValueBuilder.of(quantity);
    }

    public static Value of(OntologyClass assay, double value, ReferenceRange ref) {
        Quantity quantity = QuantityBuilder.of(assay, value, ref);
        return ValueBuilder.of(quantity);
    }

    public static Value of(OntologyClass assay, double value, double low, double high) {
        ReferenceRange ref = ReferenceRangeBuilder.of(assay, low, high);
        Quantity quantity = QuantityBuilder.of(assay, value, ref);
        return ValueBuilder.of(quantity);
    }
}

