/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.ga4gh.vrsatile.v1.VariationDescriptor;
import org.phenopackets.phenopackettools.builder.builders.VariationDescriptorBuilder;
import org.phenopackets.schema.v2.core.AcmgPathogenicityClassification;
import org.phenopackets.schema.v2.core.TherapeuticActionability;
import org.phenopackets.schema.v2.core.VariantInterpretation;

public class VariantInterpretationBuilder {
    private final VariantInterpretation.Builder builder;

    private VariantInterpretationBuilder(VariationDescriptor descriptor) {
        this.builder = VariantInterpretation.newBuilder().setVariationDescriptor(descriptor);
    }

    public static VariantInterpretation of(VariationDescriptor descriptor, AcmgPathogenicityClassification acmgPathogenicityClassification) {
        return VariantInterpretation.newBuilder().setVariationDescriptor(descriptor).setAcmgPathogenicityClassification(acmgPathogenicityClassification).build();
    }

    public static VariantInterpretation of(VariationDescriptor descriptor, AcmgPathogenicityClassification acmgPathogenicityClassification, TherapeuticActionability therapeuticActionability) {
        return VariantInterpretation.newBuilder().setVariationDescriptor(descriptor).setAcmgPathogenicityClassification(acmgPathogenicityClassification).setTherapeuticActionability(therapeuticActionability).build();
    }

    public static VariantInterpretationBuilder builder(VariationDescriptor descriptor) {
        return new VariantInterpretationBuilder(descriptor);
    }

    public static VariantInterpretationBuilder builder(VariationDescriptorBuilder builder) {
        return new VariantInterpretationBuilder(builder.build());
    }

    public VariantInterpretationBuilder acmgNotProvided() {
        this.builder.setAcmgPathogenicityClassification(AcmgPathogenicityClassification.NOT_PROVIDED);
        return this;
    }

    public VariantInterpretationBuilder benign() {
        this.builder.setAcmgPathogenicityClassification(AcmgPathogenicityClassification.BENIGN);
        return this;
    }

    public VariantInterpretationBuilder likelyBenign() {
        this.builder.setAcmgPathogenicityClassification(AcmgPathogenicityClassification.LIKELY_BENIGN);
        return this;
    }

    public VariantInterpretationBuilder uncertainSignificance() {
        this.builder.setAcmgPathogenicityClassification(AcmgPathogenicityClassification.UNCERTAIN_SIGNIFICANCE);
        return this;
    }

    public VariantInterpretationBuilder likelyPathogenic() {
        this.builder.setAcmgPathogenicityClassification(AcmgPathogenicityClassification.LIKELY_PATHOGENIC);
        return this;
    }

    public VariantInterpretationBuilder pathogenic() {
        this.builder.setAcmgPathogenicityClassification(AcmgPathogenicityClassification.PATHOGENIC);
        return this;
    }

    public VariantInterpretationBuilder actionabilityUnknown() {
        this.builder.setTherapeuticActionability(TherapeuticActionability.UNKNOWN_ACTIONABILITY);
        return this;
    }

    public VariantInterpretationBuilder notActionable() {
        this.builder.setTherapeuticActionability(TherapeuticActionability.NOT_ACTIONABLE);
        return this;
    }

    public VariantInterpretationBuilder actionable() {
        this.builder.setTherapeuticActionability(TherapeuticActionability.ACTIONABLE);
        return this;
    }

    public VariantInterpretation build() {
        return this.builder.build();
    }
}

