/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import java.util.List;
import org.ga4gh.vrs.v1.Variation;
import org.ga4gh.vrsatile.v1.Expression;
import org.ga4gh.vrsatile.v1.Extension;
import org.ga4gh.vrsatile.v1.GeneDescriptor;
import org.ga4gh.vrsatile.v1.MoleculeContext;
import org.ga4gh.vrsatile.v1.VariationDescriptor;
import org.ga4gh.vrsatile.v1.VcfRecord;
import org.phenopackets.phenopackettools.builder.builders.Extensions;
import org.phenopackets.phenopackettools.builder.builders.VcfRecordBuilder;
import org.phenopackets.phenopackettools.builder.constants.AllelicState;
import org.phenopackets.schema.v2.core.OntologyClass;

public class VariationDescriptorBuilder {
    private final VariationDescriptor.Builder builder;

    @Deprecated(forRemoval=true)
    private VariationDescriptorBuilder() {
        this.builder = VariationDescriptor.newBuilder();
    }

    private VariationDescriptorBuilder(String id) {
        this.builder = VariationDescriptor.newBuilder().setId(id);
    }

    @Deprecated(forRemoval=true, since="0.4.8")
    public static VariationDescriptorBuilder builder() {
        return new VariationDescriptorBuilder();
    }

    public static VariationDescriptorBuilder builder(String variantId) {
        return new VariationDescriptorBuilder(variantId);
    }

    public VariationDescriptorBuilder label(String lbl) {
        this.builder.setLabel(lbl);
        return this;
    }

    public VariationDescriptorBuilder variation(Variation variation) {
        this.builder.setVariation(variation);
        return this;
    }

    public VariationDescriptorBuilder description(String desc) {
        this.builder.setDescription(desc);
        return this;
    }

    public VariationDescriptorBuilder geneContext(GeneDescriptor gene) {
        this.builder.setGeneContext(gene);
        return this;
    }

    public VariationDescriptorBuilder vcfRecord(VcfRecord vcf) {
        this.builder.setVcfRecord(vcf);
        return this;
    }

    public VariationDescriptorBuilder addXref(String xref) {
        this.builder.addXrefs(xref);
        return this;
    }

    public VariationDescriptorBuilder addAllXrefs(List<String> xrefs) {
        this.builder.addAllXrefs(xrefs);
        return this;
    }

    public VariationDescriptorBuilder addAlternateLabel(String altLabel) {
        this.builder.addAlternateLabels(altLabel);
        return this;
    }

    public VariationDescriptorBuilder addAllAlternateLabels(List<String> altLabels) {
        this.builder.addAllAlternateLabels(altLabels);
        return this;
    }

    public VariationDescriptorBuilder genomic() {
        this.builder.setMoleculeContext(MoleculeContext.genomic);
        return this;
    }

    public VariationDescriptorBuilder protein() {
        this.builder.setMoleculeContext(MoleculeContext.protein);
        return this;
    }

    public VariationDescriptorBuilder transcript() {
        this.builder.setMoleculeContext(MoleculeContext.transcript);
        return this;
    }

    public VariationDescriptorBuilder structuralType(OntologyClass structuralType) {
        this.builder.setStructuralType(structuralType);
        return this;
    }

    public VariationDescriptorBuilder heterozygous() {
        this.builder.setAllelicState(AllelicState.heterozygous());
        return this;
    }

    public VariationDescriptorBuilder homozygous() {
        this.builder.setAllelicState(AllelicState.homozygous());
        return this;
    }

    public VariationDescriptorBuilder hemizygous() {
        this.builder.setAllelicState(AllelicState.hemizygous());
        return this;
    }

    public VariationDescriptorBuilder unspecifiedZygosity() {
        this.builder.setAllelicState(AllelicState.unspecifiedZygosity());
        return this;
    }

    public VariationDescriptorBuilder zygosity(OntologyClass zygo) {
        this.builder.setAllelicState(zygo);
        return this;
    }

    public VariationDescriptorBuilder hgvs(String value) {
        Expression expression = Expression.newBuilder().setSyntax("hgvs").setValue(value).build();
        this.builder.addExpressions(expression);
        return this;
    }

    public VariationDescriptorBuilder spdi(String value) {
        Expression expression = Expression.newBuilder().setSyntax("spdi").setValue(value).build();
        this.builder.addExpressions(expression);
        return this;
    }

    public VariationDescriptorBuilder iscn(String value) {
        Expression expression = Expression.newBuilder().setSyntax("iscn").setValue(value).build();
        this.builder.addExpressions(expression);
        return this;
    }

    public VariationDescriptorBuilder addExpression(Expression expression) {
        this.builder.addExpressions(expression);
        return this;
    }

    public VariationDescriptorBuilder vcfHg38(String chromosome, int position, String ref, String alt) {
        VcfRecord vcf = VcfRecordBuilder.of("GRCh38", chromosome, position, ref, alt);
        this.builder.setVcfRecord(vcf);
        return this;
    }

    public VariationDescriptorBuilder vcfHg37(String chromosome, int position, String ref, String alt) {
        VcfRecord vcf = VcfRecordBuilder.of("GRCh37", chromosome, position, ref, alt);
        this.builder.setVcfRecord(vcf);
        return this;
    }

    public VariationDescriptorBuilder mosaicism(double percentage) {
        Extension percentageExtension = Extensions.mosaicism(percentage);
        this.builder.addExtensions(percentageExtension);
        return this;
    }

    public VariationDescriptorBuilder alleleFrequency(double frequency) {
        Extension alleleFrequencyExtension = Extensions.alleleFrequency(frequency);
        this.builder.addExtensions(alleleFrequencyExtension);
        return this;
    }

    public VariationDescriptor build() {
        return this.builder.build();
    }
}

