/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.ga4gh.vrsatile.v1.VcfRecord;

public class VcfRecordBuilder {
    private final VcfRecord.Builder builder;

    private VcfRecordBuilder(String assembly, String chromosome, int position, String ref, String alt) {
        this.builder = VcfRecord.newBuilder().setGenomeAssembly(assembly).setChrom(chromosome).setPos((long)position).setRef(ref).setAlt(alt);
    }

    public static VcfRecord of(String assembly, String chromosome, int position, String ref, String alt) {
        return VcfRecord.newBuilder().setGenomeAssembly(assembly).setChrom(chromosome).setPos((long)position).setRef(ref).setAlt(alt).build();
    }

    public static VcfRecordBuilder builder(String assembly, String chromosome, int position, String ref, String alt) {
        return new VcfRecordBuilder(assembly, chromosome, position, ref, alt);
    }

    public VcfRecordBuilder id(String id) {
        this.builder.setId(id);
        return this;
    }

    public VcfRecordBuilder qual(String qual) {
        this.builder.setQual(qual);
        return this;
    }

    public VcfRecordBuilder pass() {
        this.builder.setFilter("PASS");
        return this;
    }

    public VcfRecordBuilder filter(String filter) {
        this.builder.setFilter(filter);
        return this;
    }

    public VcfRecordBuilder info(String info) {
        this.builder.setInfo(info);
        return this;
    }

    public VcfRecord build() {
        return this.builder.build();
    }
}

