/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.io;

import com.google.protobuf.Message;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.phenopackets.phenopackettools.core.PhenopacketElement;
import org.phenopackets.phenopackettools.core.PhenopacketFormat;
import org.phenopackets.phenopackettools.util.format.FormatSniffer;
import org.phenopackets.phenopackettools.util.format.SniffException;

public interface PhenopacketParser {
    public Message parse(PhenopacketFormat var1, PhenopacketElement var2, InputStream var3) throws IOException;

    default public Message parse(PhenopacketFormat format, PhenopacketElement element, Path path) throws IOException {
        try (BufferedInputStream is = PhenopacketParser.openInputStream(path);){
            Message message = this.parse(format, element, is);
            return message;
        }
    }

    default public Message parse(PhenopacketFormat format, InputStream is) throws IOException {
        PhenopacketElement element = PhenopacketParser.sniffElement(is);
        return this.parse(format, element, is);
    }

    default public Message parse(PhenopacketFormat format, Path path) throws IOException {
        try (BufferedInputStream is = PhenopacketParser.openInputStream(path);){
            Message message = this.parse(format, (InputStream)is);
            return message;
        }
    }

    default public Message parse(PhenopacketElement element, InputStream is) throws IOException, SniffException {
        PhenopacketFormat format = PhenopacketParser.sniffFormat(is);
        return this.parse(format, element, is);
    }

    default public Message parse(PhenopacketElement element, Path path) throws IOException, SniffException {
        try (BufferedInputStream is = PhenopacketParser.openInputStream(path);){
            Message message = this.parse(element, (InputStream)is);
            return message;
        }
    }

    default public Message parse(InputStream is) throws IOException, SniffException {
        PhenopacketFormat format = PhenopacketParser.sniffFormat(is);
        return this.parse(format, is);
    }

    default public Message parse(Path path) throws IOException, SniffException {
        try (BufferedInputStream is = PhenopacketParser.openInputStream(path);){
            Message message = this.parse(is);
            return message;
        }
    }

    private static PhenopacketElement sniffElement(InputStream is) {
        return PhenopacketElement.PHENOPACKET;
    }

    private static PhenopacketFormat sniffFormat(InputStream is) throws SniffException, IOException {
        return FormatSniffer.sniff((InputStream)is);
    }

    private static BufferedInputStream openInputStream(Path path) throws IOException {
        return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
    }
}

