/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.util.format;

import java.io.IOException;
import java.io.InputStream;
import org.phenopackets.phenopackettools.core.PhenopacketElement;
import org.phenopackets.phenopackettools.core.PhenopacketFormat;
import org.phenopackets.phenopackettools.core.PhenopacketSchemaVersion;
import org.phenopackets.phenopackettools.util.format.ElementSniffException;
import org.phenopackets.phenopackettools.util.format.SniffException;
import org.phenopackets.phenopackettools.util.format.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSniffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementSniffer.class);
    static final int BUFFER_SIZE = 32;

    private ElementSniffer() {
    }

    public static PhenopacketElement sniff(InputStream input, PhenopacketSchemaVersion schemaVersion, PhenopacketFormat format) throws IOException, SniffException {
        return ElementSniffer.sniff(Util.getFirstBytesAndReset(input, 32), schemaVersion, format);
    }

    public static PhenopacketElement sniff(byte[] payload, PhenopacketSchemaVersion schemaVersion, PhenopacketFormat format) throws ElementSniffException {
        if (payload.length < 32) {
            throw new ElementSniffException("Need at least %d bytes to sniff but got %d".formatted(32, payload.length));
        }
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case PhenopacketFormat.PROTOBUF -> ElementSniffer.sniffProtobuf(payload, schemaVersion);
            case PhenopacketFormat.JSON -> ElementSniffer.sniffJson(payload, schemaVersion);
            case PhenopacketFormat.YAML -> ElementSniffer.sniffYaml(payload, schemaVersion);
        };
    }

    private static PhenopacketElement sniffProtobuf(byte[] payload, PhenopacketSchemaVersion schemaVersion) {
        LOGGER.debug("Sniffing is not yet implemented, assuming {}", (Object)PhenopacketElement.PHENOPACKET);
        return PhenopacketElement.PHENOPACKET;
    }

    private static PhenopacketElement sniffJson(byte[] payload, PhenopacketSchemaVersion schemaVersion) {
        LOGGER.debug("Sniffing is not yet implemented, assuming {}", (Object)PhenopacketElement.PHENOPACKET);
        return PhenopacketElement.PHENOPACKET;
    }

    private static PhenopacketElement sniffYaml(byte[] payload, PhenopacketSchemaVersion schemaVersion) {
        LOGGER.debug("Sniffing is not yet implemented, assuming {}", (Object)PhenopacketElement.PHENOPACKET);
        return PhenopacketElement.PHENOPACKET;
    }
}

