/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.util.format;

import java.io.IOException;
import java.io.InputStream;
import org.phenopackets.phenopackettools.core.PhenopacketFormat;
import org.phenopackets.phenopackettools.util.format.FormatSniffException;
import org.phenopackets.phenopackettools.util.format.SniffException;
import org.phenopackets.phenopackettools.util.format.Util;

public class FormatSniffer {
    static final int BUFFER_SIZE = 32;

    private FormatSniffer() {
    }

    public static PhenopacketFormat sniff(byte[] payload) throws FormatSniffException {
        if (payload.length < 32) {
            throw new FormatSniffException("Need at least %d bytes to sniff but got %d".formatted(32, payload.length));
        }
        if (Util.looksLikeJson(payload)) {
            return PhenopacketFormat.JSON;
        }
        if (Util.looksLikeYaml(payload)) {
            return PhenopacketFormat.YAML;
        }
        return PhenopacketFormat.PROTOBUF;
    }

    public static PhenopacketFormat sniff(InputStream input) throws IOException, SniffException {
        return FormatSniffer.sniff(Util.getFirstBytesAndReset(input, 32));
    }
}

