/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.util.format;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.phenopackets.phenopackettools.util.format.SniffException;

class Util {
    private static final Pattern YAML_HEADER = Pattern.compile("((phenopacket)|(family)|(cohort)):");

    private Util() {
    }

    static boolean looksLikeJson(byte[] payload) {
        String head = new String(payload, 0, 32);
        return Util.looksLikeJson(head);
    }

    static boolean looksLikeJson(String head) {
        return head.replace("\\W+", "").startsWith("{");
    }

    static boolean looksLikeYaml(byte[] payload) {
        boolean bl;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(payload)));
        try {
            String line = reader.readLine();
            Matcher matcher = YAML_HEADER.matcher(line);
            bl = matcher.matches();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    static byte[] getFirstBytesAndReset(InputStream input, int nBytes) throws SniffException, IOException {
        if (input.markSupported()) {
            byte[] buffer = new byte[nBytes];
            input.mark(nBytes);
            int read = input.read(buffer);
            if (read < nBytes) {
                String message = read < 0 ? "The stream must not be at the end" : "Need at least %d bytes to sniff the format but only %d was available".formatted(nBytes, read);
                throw new SniffException(message);
            }
            input.reset();
            return buffer;
        }
        throw new SniffException("The provided InputStream does not support `mark()`");
    }
}

