/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.util.print;

import com.google.protobuf.Descriptors;
import com.google.protobuf.util.JsonFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.phenopackets.schema.v2.Cohort;
import org.phenopackets.schema.v2.Family;
import org.phenopackets.schema.v2.Phenopacket;

public class PhenopacketPrintUtil {
    private static final JsonFormat.Parser PARSER = JsonFormat.parser();
    private static final JsonFormat.Printer PRINTER = JsonFormat.printer().includingDefaultValueFields(PhenopacketPrintUtil.defaultValueFields());

    private static Set<Descriptors.FieldDescriptor> defaultValueFields() {
        Set<Descriptors.FieldDescriptor.JavaType> serializeDefaultValues = Set.of(Descriptors.FieldDescriptor.JavaType.ENUM, Descriptors.FieldDescriptor.JavaType.BOOLEAN);
        return Stream.of(PhenopacketPrintUtil.findDescriptors(Phenopacket.getDescriptor(), serializeDefaultValues), PhenopacketPrintUtil.findDescriptors(Family.getDescriptor(), serializeDefaultValues), PhenopacketPrintUtil.findDescriptors(Cohort.getDescriptor(), serializeDefaultValues)).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    public static JsonFormat.Parser getParser() {
        return PARSER;
    }

    public static JsonFormat.Printer getPrinter() {
        return PRINTER;
    }

    private static Stream<Descriptors.FieldDescriptor> findDescriptors(Descriptors.Descriptor base, Set<Descriptors.FieldDescriptor.JavaType> targetTypes) {
        Stream.Builder<Descriptors.FieldDescriptor> builder = Stream.builder();
        HashSet<Descriptors.Descriptor> visited = new HashSet<Descriptors.Descriptor>();
        PhenopacketPrintUtil.findDescriptors(base, targetTypes, builder, visited);
        return builder.build();
    }

    private static void findDescriptors(Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor.JavaType> targetTypes, Stream.Builder<Descriptors.FieldDescriptor> builder, Set<Descriptors.Descriptor> visited) {
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            if (targetTypes.contains(field.getJavaType())) {
                builder.add(field);
            }
            if (!field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE) || visited.contains(field.getMessageType())) continue;
            visited.add(field.getMessageType());
            PhenopacketPrintUtil.findDescriptors(field.getMessageType(), targetTypes, builder, visited);
        }
    }

    private PhenopacketPrintUtil() {
    }
}

