/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.util.format;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.phenopackets.phenopackettools.util.format.SniffException;

class Util {
    private static final String[] FIELD_NAMES = new String[]{"id", "subject", "phenotypicFeatures", "measurements", "biosamples", "interpretations", "diseases", "medicalActions", "files", "metaData", "proband", "relatives", "pedigree", "description", "members", "genes", "variants", "resolutionStatus", "diagnosis", "phenopacket", "family"};
    private static final String FIELD_GROUPS = Arrays.stream(FIELD_NAMES).map(arg_0 -> Util.lambda$static$0("(%s)", arg_0)).collect(Collectors.joining("|", "^(", ")"));
    private static final Pattern YAML_HEADER = Pattern.compile(FIELD_GROUPS);
    private static final Pattern JSON_HEAD = Pattern.compile("^\\s*\\{");

    private Util() {
    }

    static boolean looksLikeJson(byte[] payload) {
        String head = new String(payload, StandardCharsets.UTF_8);
        return Util.looksLikeJson(head);
    }

    static boolean looksLikeJson(String head) {
        Matcher matcher = JSON_HEAD.matcher(head);
        return matcher.find();
    }

    static boolean looksLikeYaml(byte[] payload) {
        String string = new String(payload, StandardCharsets.UTF_8);
        for (String line : string.split("\n")) {
            Matcher matcher;
            if (line.startsWith("#") || line.startsWith("---") || line.startsWith("...") || !(matcher = YAML_HEADER.matcher(line)).find()) continue;
            return true;
        }
        return false;
    }

    static byte[] getAtMostNFirstBytesAndReset(InputStream input, int nBytes) throws SniffException, IOException {
        if (input.markSupported()) {
            byte[] buffer = new byte[nBytes];
            input.mark(nBytes);
            input.read(buffer);
            input.reset();
            return buffer;
        }
        throw new SniffException("The provided InputStream does not support `mark()`");
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "(%s)".formatted(xva$0);
    }
}

