/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class P3DRect
extends PNode {
    private static final long serialVersionUID = 1L;
    private Color topLeftOuterColor;
    private Color topLeftInnerColor;
    private Color bottomRightInnerColor;
    private Color bottomRightOuterColor;
    private transient GeneralPath path = null;
    private transient Stroke stroke = null;
    private boolean raised = true;

    public P3DRect() {
    }

    public P3DRect(Rectangle2D bounds) {
        this(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public P3DRect(double x, double y, double width, double height) {
        this();
        this.setBounds(x, y, width, height);
    }

    public void setRaised(boolean raised) {
        this.raised = raised;
        this.setPaint(this.getPaint());
    }

    public boolean getRaised() {
        return this.raised;
    }

    protected void paint(PPaintContext paintContext) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(0.0f);
        }
        if (this.path == null) {
            this.path = new GeneralPath();
        }
        Graphics2D g2 = paintContext.getGraphics();
        double x = this.getX();
        double y = this.getY();
        double width = this.getWidth();
        double height = this.getHeight();
        double scaleX = g2.getTransform().getScaleX();
        double scaleY = g2.getTransform().getScaleY();
        double dx = (float)(1.0 / scaleX);
        double dy = (float)(1.0 / scaleY);
        PBounds bounds = this.getBounds();
        g2.setPaint(this.getPaint());
        g2.fill((Shape)bounds);
        g2.setStroke(this.stroke);
        this.path.reset();
        this.path.moveTo((float)(x + width), (float)y);
        this.path.lineTo((float)x, (float)y);
        this.path.lineTo((float)x, (float)(y + height));
        g2.setPaint(this.topLeftOuterColor);
        g2.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(x + width), (float)(y + dy));
        this.path.lineTo((float)(x + dx), (float)(y + dy));
        this.path.lineTo((float)(x + dx), (float)(y + height));
        g2.setPaint(this.topLeftInnerColor);
        g2.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(x + width), (float)y);
        this.path.lineTo((float)(x + width), (float)(y + height));
        this.path.lineTo((float)x, (float)(y + height));
        g2.setPaint(this.bottomRightOuterColor);
        g2.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(x + width - dx), (float)(y + dy));
        this.path.lineTo((float)(x + width - dx), (float)(y + height - dy));
        this.path.lineTo((float)x, (float)(y + height - dy));
        g2.setPaint(this.bottomRightInnerColor);
        g2.draw(this.path);
    }

    public void setPaint(Paint newPaint) {
        super.setPaint(newPaint);
        if (newPaint instanceof Color) {
            Color color = (Color)newPaint;
            if (this.raised) {
                this.setRaisedEdges(color);
            } else {
                this.setRecessedEdges(color);
            }
        } else {
            this.setNoEdges();
        }
    }

    private void setRaisedEdges(Color color) {
        this.topLeftOuterColor = color.brighter();
        this.topLeftInnerColor = this.topLeftOuterColor.brighter();
        this.bottomRightInnerColor = color.darker();
        this.bottomRightOuterColor = this.bottomRightInnerColor.darker();
    }

    private void setNoEdges() {
        this.topLeftOuterColor = null;
        this.topLeftInnerColor = null;
        this.bottomRightInnerColor = null;
        this.bottomRightOuterColor = null;
    }

    private void setRecessedEdges(Color color) {
        this.topLeftOuterColor = color.darker();
        this.topLeftInnerColor = this.topLeftOuterColor.darker();
        this.bottomRightInnerColor = color.brighter();
        this.bottomRightOuterColor = this.bottomRightInnerColor.brighter();
    }

    public static void main(String[] args) {
    }
}

