/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolox.swing.PScrollPaneLayout;
import edu.umd.cs.piccolox.swing.PViewport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ScrollPaneUI;

public class PScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    protected PNullAction nullAction = null;
    protected boolean disableKeyActions = false;
    private final AdjustmentListener scrollAdjustmentListener = new AdjustmentListener(){
        private boolean lastAdjustingState = false;

        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (event.getSource() instanceof JScrollBar) {
                JScrollBar scrollBar = (JScrollBar)event.getSource();
                this.setAdjusting(scrollBar.getValueIsAdjusting());
            }
        }

        private void setAdjusting(boolean isAdjusting) {
            if (isAdjusting != this.lastAdjustingState) {
                Component c = PScrollPane.this.getViewport().getView();
                if (c instanceof PCanvas) {
                    ((PCanvas)c).setInteracting(isAdjusting);
                }
                this.lastAdjustingState = isAdjusting;
            }
        }
    };

    public PScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        PScrollPaneLayout.UIResource layout = new PScrollPaneLayout.UIResource();
        this.setLayout(layout);
        layout.syncWithScrollPane(this);
        this.horizontalScrollBar.addAdjustmentListener(this.scrollAdjustmentListener);
        this.verticalScrollBar.addAdjustmentListener(this.scrollAdjustmentListener);
    }

    public void setVerticalScrollBar(JScrollBar newVerticalScrollBar) {
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.removeAdjustmentListener(this.scrollAdjustmentListener);
        }
        super.setVerticalScrollBar(newVerticalScrollBar);
        newVerticalScrollBar.addAdjustmentListener(this.scrollAdjustmentListener);
    }

    public void setHorizontalScrollBar(JScrollBar newHorizontalScrollBar) {
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.removeAdjustmentListener(this.scrollAdjustmentListener);
        }
        super.setHorizontalScrollBar(newHorizontalScrollBar);
        newHorizontalScrollBar.addAdjustmentListener(this.scrollAdjustmentListener);
    }

    public PScrollPane(Component view) {
        this(view, 20, 30);
    }

    public PScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public PScrollPane() {
        this(null, 20, 30);
    }

    public void setKeyActionsDisabled(boolean disable) {
        if (disable && this.disableKeyActions != disable) {
            this.disableKeyActions = disable;
            this.disableKeyActions();
        } else if (!disable && this.disableKeyActions != disable) {
            this.disableKeyActions = disable;
            this.installCustomKeyActions();
        }
    }

    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        if (!this.disableKeyActions) {
            this.installCustomKeyActions();
        } else {
            this.disableKeyActions();
        }
    }

    protected void installCustomKeyActions() {
        ActionMap map = this.getActionMap();
        map.put("scrollUp", new PScrollAction("scrollUp", 1, -1, true));
        map.put("scrollDown", new PScrollAction("scrollDown", 1, 1, true));
        map.put("scrollLeft", new PScrollAction("scrollLeft", 0, -1, true));
        map.put("scrollRight", new PScrollAction("ScrollRight", 0, 1, true));
        map.put("unitScrollRight", new PScrollAction("UnitScrollRight", 0, 1, false));
        map.put("unitScrollLeft", new PScrollAction("UnitScrollLeft", 0, -1, false));
        map.put("unitScrollUp", new PScrollAction("UnitScrollUp", 1, -1, false));
        map.put("unitScrollDown", new PScrollAction("UnitScrollDown", 1, 1, false));
        map.put("scrollEnd", new PScrollEndAction("ScrollEnd"));
        map.put("scrollHome", new PScrollHomeAction("ScrollHome"));
    }

    protected void disableKeyActions() {
        ActionMap map = this.getActionMap();
        if (this.nullAction == null) {
            this.nullAction = new PNullAction();
        }
        map.put("scrollUp", this.nullAction);
        map.put("scrollDown", this.nullAction);
        map.put("scrollLeft", this.nullAction);
        map.put("scrollRight", this.nullAction);
        map.put("unitScrollRight", this.nullAction);
        map.put("unitScrollLeft", this.nullAction);
        map.put("unitScrollUp", this.nullAction);
        map.put("unitScrollDown", this.nullAction);
        map.put("scrollEnd", this.nullAction);
        map.put("scrollHome", this.nullAction);
    }

    protected JViewport createViewport() {
        return new PViewport();
    }

    protected static class PNullAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected PNullAction() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected static class PScrollEndAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected PScrollEndAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            JViewport vp;
            JScrollPane scrollpane = (JScrollPane)event.getSource();
            if ((scrollpane.getVerticalScrollBar().isShowing() || scrollpane.getHorizontalScrollBar().isShowing()) && (vp = scrollpane.getViewport()) != null && vp.getView() != null) {
                Rectangle visRect = vp.getViewRect();
                Dimension size = vp.getViewSize();
                vp.setViewPosition(new Point(size.width - visRect.width, size.height - visRect.height));
            }
        }
    }

    private static class PScrollHomeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected PScrollHomeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            JViewport vp;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            if ((scrollpane.getVerticalScrollBar().isShowing() || scrollpane.getHorizontalScrollBar().isShowing()) && (vp = scrollpane.getViewport()) != null && vp.getView() != null) {
                vp.setViewPosition(new Point(0, 0));
            }
        }
    }

    protected static class PScrollAction
    extends AbstractAction {
        private static final int MINIMUM_SCROLL_SIZE = 10;
        private static final long serialVersionUID = 1L;
        protected int orientation;
        protected int direction;
        private final boolean block;

        protected PScrollAction(String name, int orientation, int direction, boolean block) {
            super(name);
            this.orientation = orientation;
            this.direction = direction;
            this.block = block;
        }

        public void actionPerformed(ActionEvent event) {
            JScrollPane scrollpane = (JScrollPane)event.getSource();
            if (!this.isScrollEventOnVisibleScrollbars(scrollpane)) {
                return;
            }
            JViewport vp = scrollpane.getViewport();
            if (vp == null) {
                return;
            }
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Rectangle visRect = vp.getViewRect();
            Dimension vSize = vp.getViewSize();
            int amount = view instanceof Scrollable ? (this.block ? ((Scrollable)((Object)view)).getScrollableBlockIncrement(visRect, this.orientation, this.direction) : ((Scrollable)((Object)view)).getScrollableUnitIncrement(visRect, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? visRect.height : visRect.width) : 10);
            if (this.orientation == 1) {
                visRect.y += amount * this.direction;
                if (visRect.y + visRect.height > vSize.height) {
                    visRect.y = Math.max(0, vSize.height - visRect.height);
                } else if (visRect.y < 0) {
                    visRect.y = 0;
                }
            } else {
                visRect.x += amount * this.direction;
                if (visRect.x + visRect.width > vSize.width) {
                    visRect.x = Math.max(0, vSize.width - visRect.width);
                } else if (visRect.x < 0) {
                    visRect.x = 0;
                }
            }
            vp.setViewPosition(visRect.getLocation());
        }

        private boolean isScrollEventOnVisibleScrollbars(JScrollPane scrollpane) {
            return this.orientation == 1 && scrollpane.getVerticalScrollBar().isShowing() || this.orientation == 0 && scrollpane.getHorizontalScrollBar().isShowing();
        }
    }
}

