/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.geom.Rectangle2D;

public class POcclusionDetection {
    public void detectOccusions(PNode n, PBounds parentBounds) {
        this.detectOcclusions(n, new PPickPath(null, parentBounds));
    }

    public void detectOcclusions(PNode node, PPickPath pickPath) {
        if (!node.fullIntersects((Rectangle2D)pickPath.getPickBounds())) {
            return;
        }
        pickPath.pushTransform(node.getTransformReference(false));
        int count = node.getChildrenCount();
        for (int i = count - 1; i >= 0; --i) {
            PNode each = node.getChild(i);
            if (node.getOccluded()) {
                each.setOccluded(true);
                continue;
            }
            this.detectOcclusions(each, pickPath);
        }
        if (this.nodeOccludesParents(node, pickPath)) {
            PNode parent = node.getParent();
            while (parent != null && !parent.getOccluded()) {
                parent.setOccluded(true);
            }
        }
        pickPath.popTransform(node.getTransformReference(false));
    }

    private boolean nodeOccludesParents(PNode n, PPickPath pickPath) {
        return !n.getOccluded() && n.intersects((Rectangle2D)pickPath.getPickBounds()) && n.isOpaque((Rectangle2D)pickPath.getPickBounds());
    }
}

