/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class XYArray
implements MutablePoints,
Cloneable {
    private double[] points = null;
    private int numPoints = 0;

    public XYArray(double[] points) {
        this.initPoints(points, points.length / 2);
    }

    public XYArray(int n) {
        this.initPoints(null, n);
    }

    public XYArray() {
        this(0);
    }

    public int getPointCount() {
        return this.numPoints;
    }

    private int normalize(int i) {
        if (i >= this.numPoints) {
            throw new IllegalArgumentException("The point index " + i + " is not below " + this.numPoints);
        }
        if (i < 0) {
            return this.numPoints + i;
        }
        return i;
    }

    public double getX(int i) {
        return this.points[this.normalize(i) * 2];
    }

    public double getY(int i) {
        return this.points[this.normalize(i) * 2 + 1];
    }

    public Point2D getPoint(int i, Point2D dst) {
        int pointIndex = this.normalize(i);
        dst.setLocation(this.points[pointIndex * 2], this.points[pointIndex * 2 + 1]);
        return dst;
    }

    public void setX(int i, double x) {
        this.points[this.normalize((int)i) * 2] = x;
    }

    public void setY(int i, double y) {
        this.points[this.normalize((int)i) * 2 + 1] = y;
    }

    public void setPoint(int i, double x, double y) {
        int pointIndex = this.normalize(i);
        this.points[pointIndex * 2] = x;
        this.points[pointIndex * 2 + 1] = y;
    }

    public void setPoint(int i, Point2D pt) {
        this.setPoint(i, pt.getX(), pt.getY());
    }

    public void transformPoints(AffineTransform t) {
        t.transform(this.points, 0, this.points, 0, this.numPoints);
    }

    public Rectangle2D getBounds(Rectangle2D dst) {
        int i = 0;
        if (dst.isEmpty() && this.getPointCount() > 0) {
            dst.setRect(this.getX(i), this.getY(i), 1.0, 1.0);
            ++i;
        }
        while (i < this.getPointCount()) {
            dst.add(this.getX(i), this.getY(i));
            ++i;
        }
        return dst;
    }

    public static double[] initPoints(double[] points, int n, double[] old) {
        double[] result = points == null || n * 2 > points.length ? new double[n * 2] : points;
        if (old != null && result != old) {
            System.arraycopy(old, 0, result, 0, Math.min(old.length, n * 2));
        }
        return result;
    }

    private void initPoints(double[] srcPoints, int n) {
        this.points = XYArray.initPoints(srcPoints, n, this.points);
        this.numPoints = srcPoints == null ? 0 : srcPoints.length / 2;
    }

    public void addPoints(int index, Points newPoints, int start, int end) {
        int sanitizedEnd = end < 0 ? newPoints.getPointCount() + end + 1 : end;
        int n = this.numPoints + sanitizedEnd - start;
        this.points = XYArray.initPoints(this.points, n, this.points);
        int pos1 = index * 2;
        int pos2 = (index + sanitizedEnd - start) * 2;
        int len = (this.numPoints - index) * 2;
        System.arraycopy(this.points, pos1, this.points, pos2, len);
        this.numPoints = n;
        if (newPoints != null) {
            int count = 0;
            for (int currentPos = start; currentPos < sanitizedEnd; ++currentPos) {
                this.setPoint(index + count, newPoints.getX(currentPos), newPoints.getY(currentPos));
                ++count;
            }
        }
    }

    public void addPoints(int pos, Points pts) {
        this.addPoints(pos, pts, 0, pts.getPointCount());
    }

    public void appendPoints(Points pts) {
        this.addPoints(this.numPoints, pts);
    }

    public static XYArray copyPoints(Points pts) {
        XYArray newList = new XYArray(pts.getPointCount());
        newList.appendPoints(pts);
        return newList;
    }

    public void addPoint(int pos, double x, double y) {
        this.addPoints(pos, null, 0, 1);
        this.setPoint(pos, x, y);
    }

    public void addPoint(int pos, Point2D pt) {
        this.addPoint(pos, pt.getX(), pt.getY());
    }

    public void removePoints(int pos, int num) {
        int sanitizedNum = Math.min(num, this.numPoints - pos);
        if (sanitizedNum > 0) {
            System.arraycopy(this.points, (pos + sanitizedNum) * 2, this.points, pos * 2, (this.numPoints - (pos + sanitizedNum)) * 2);
            this.numPoints -= sanitizedNum;
        }
    }

    public void removeAllPoints() {
        this.removePoints(0, this.numPoints);
    }

    public Object clone() {
        XYArray ps = null;
        try {
            ps = (XYArray)super.clone();
            ps.points = XYArray.initPoints(ps.points, this.numPoints, this.points);
            ps.numPoints = this.numPoints;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ps;
    }
}

