/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.security.PicketBoxMessages;

public class FilePassword {
    private File passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FilePassword(String file) {
        block9: {
            InputStream is;
            FileOutputStream fos;
            URL url = null;
            try {
                url = new URL(file);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (url == null) {
                this.passwordFile = new File(file);
            } else {
                int b;
                fos = null;
                is = null;
                is = url.openStream();
                this.passwordFile = File.createTempFile("temp", null);
                this.passwordFile.deleteOnExit();
                fos = new FileOutputStream(this.passwordFile);
                while ((b = is.read()) >= 0) {
                    fos.write(b);
                }
                this.safeClose(fos);
                FilePassword.safeClose(is);
            }
            break block9;
            catch (IOException e) {
                this.safeClose(fos);
                FilePassword.safeClose(is);
                catch (Throwable throwable) {
                    this.safeClose(fos);
                    FilePassword.safeClose(is);
                    throw throwable;
                }
            }
        }
    }

    public char[] toCharArray() throws IOException {
        RandomAccessFile raf = null;
        try {
            char[] password;
            raf = new RandomAccessFile(this.passwordFile, "r");
            char[] cArray = password = FilePassword.decode(raf);
            this.safeClose(raf);
            return cArray;
        }
        catch (Exception e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(raf);
                throw throwable;
            }
        }
    }

    static char[] decode(RandomAccessFile passwordFile) throws Exception {
        int b;
        byte[] salt = new byte[8];
        passwordFile.readFully(salt);
        int count = passwordFile.readInt();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = passwordFile.read()) >= 0) {
            baos.write(b);
        }
        passwordFile.close();
        byte[] secret = baos.toByteArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return new String(decode, "UTF-8").toCharArray();
    }

    static void encode(RandomAccessFile passwordFile, byte[] salt, int count, byte[] secret) throws Exception {
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
        cipher.init(1, (Key)cipherKey, cipherSpec);
        byte[] encode = cipher.doFinal(secret);
        passwordFile.write(salt);
        passwordFile.writeInt(count);
        passwordFile.write(encode);
        passwordFile.close();
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println(PicketBoxMessages.MESSAGES.filePasswordUsageMessage());
        }
        byte[] salt = args[0].substring(0, 8).getBytes();
        int count = Integer.parseInt(args[1]);
        byte[] passwordBytes = args[2].getBytes("UTF-8");
        RandomAccessFile passwordFile = new RandomAccessFile(args[3], "rws");
        FilePassword.encode(passwordFile, salt, count, passwordBytes);
    }
}

