/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.AuthenticationConfigParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationInfo
extends BaseAuthenticationInfo {
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    private CallbackHandler callbackHandler;

    public AuthenticationInfo() {
        this(null);
    }

    public AuthenticationInfo(String name) {
        this.name = name;
    }

    public void addAppConfigurationEntry(AppConfigurationEntry entry) {
        this.moduleEntries.add(entry);
    }

    public void setAppConfigurationEntry(AppConfigurationEntry[] loginModules) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.moduleEntries.addAll(Arrays.asList(loginModules));
    }

    public void setAppConfigurationEntry(List<AppConfigurationEntry> listOfEntries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.moduleEntries.addAll(listOfEntries);
    }

    public CallbackHandler getAppCallbackHandler() {
        return this.callbackHandler;
    }

    public void setAppCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AppConfigurationEntry[]:\n");
        int i = 0;
        while (i < this.moduleEntries.size()) {
            AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
            buffer.append("[" + i + "]");
            buffer.append("\nLoginModule Class: " + entry.getLoginModuleName());
            buffer.append("\nControlFlag: " + entry.getControlFlag());
            buffer.append("\nOptions:\n");
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> e : options.entrySet()) {
                String value;
                String name = e.getKey();
                String string = value = e.getValue() == null ? "" : e.getValue().toString();
                if (name.toLowerCase().equals("password") || name.toLowerCase().equals("bindcredential") || name.toLowerCase().equals("java.naming.security.credentials")) {
                    value = "****";
                }
                buffer.append("name=" + name);
                buffer.append(", value=" + value);
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    protected BaseSecurityInfo<Object> create(String name) {
        return new AuthenticationInfo(name);
    }

    public void writeContent(XMLStreamWriter writer) throws XMLStreamException {
        int i = 0;
        while (i < this.moduleEntries.size()) {
            AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
            writer.writeStartElement(Element.LOGIN_MODULE.getLocalName());
            String code = entry.getLoginModuleName();
            if (AuthenticationConfigParser.loginModulesMap.containsValue(code)) {
                String value = null;
                Set<Map.Entry<String, String>> entries = AuthenticationConfigParser.loginModulesMap.entrySet();
                for (Map.Entry<String, String> mapEntry : entries) {
                    if (!mapEntry.getValue().equals(code)) continue;
                    value = mapEntry.getKey();
                    break;
                }
                writer.writeAttribute(Attribute.CODE.getLocalName(), value);
            } else {
                writer.writeAttribute(Attribute.CODE.getLocalName(), code);
            }
            writer.writeAttribute(Attribute.FLAG.getLocalName(), this.valueOf(entry.getControlFlag()));
            Map<String, ?> options = entry.getOptions();
            if (options != null && options.size() > 0) {
                for (Map.Entry<String, ?> option : options.entrySet()) {
                    writer.writeStartElement(Element.MODULE_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), option.getKey());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), option.getValue().toString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            ++i;
        }
        writer.writeEndElement();
    }

    private String valueOf(AppConfigurationEntry.LoginModuleControlFlag controlFlag) {
        if (controlFlag.equals(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL)) {
            return "optional";
        }
        if (controlFlag.equals(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED)) {
            return "required";
        }
        if (controlFlag.equals(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE)) {
            return "requisite";
        }
        return "sufficient";
    }
}

