/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.DecodeAction;
import org.jboss.security.auth.spi.SecurityActions;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.vault.SecurityVaultUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapLoginModule
extends UsernamePasswordLoginModule {
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    private static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"principalDNPrefix", "principalDNSuffix", "rolesCtxDN", "userRolesCtxDNAttributeName", "uidAttributeID", "roleAttributeID", "matchOnUserDN", "roleAttributeIsDN", "roleNameAttributeID", "searchTimeLimit", "searchScope", "jaasSecurityDomain", "allowEmptyPasswords", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.factory.state", "java.naming.factory.url.pkgs", "java.naming.provider.url", "java.naming.dns.url", "java.naming.authoritative", "java.naming.batchsize", "java.naming.referral", "java.naming.security.protocol", "java.naming.security.authentication", "java.naming.security.principal", "java.naming.security.credentials", "java.naming.language", "java.naming.applet"};
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        return "";
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    @Override
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = false;
                String flag = (String)this.options.get(ALLOW_EMPTY_PASSWORDS);
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    PicketBoxLogger.LOGGER.traceRejectingEmptyPassword();
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                this.createLdapInitContext(username, inputPassword);
                isValid = true;
            }
            catch (Throwable e) {
                super.setValidateError(e);
            }
        }
        return isValid;
    }

    private void createLdapInitContext(String username, Object credential) throws Exception {
        block46: {
            String principalDNSuffix;
            String principalDNPrefix;
            String authType;
            Properties env = new Properties();
            for (Map.Entry entry : this.options.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
            String factoryName = env.getProperty("java.naming.factory.initial");
            if (factoryName == null) {
                factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
                env.setProperty("java.naming.factory.initial", factoryName);
            }
            if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
                env.setProperty("java.naming.security.authentication", "simple");
            }
            String protocol = env.getProperty("java.naming.security.protocol");
            String providerURL = (String)this.options.get("java.naming.provider.url");
            if (providerURL == null) {
                providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
            }
            String bindDN = (String)this.options.get("java.naming.security.principal");
            String bindCredential = (String)this.options.get("java.naming.security.credentials");
            String securityDomain = (String)this.options.get(SECURITY_DOMAIN_OPT);
            if (securityDomain != null) {
                ObjectName serviceName = new ObjectName(securityDomain);
                char[] tmp = DecodeAction.decode(bindCredential, serviceName);
                bindCredential = new String(tmp);
            }
            if (bindCredential != null && SecurityVaultUtil.isVaultFormat((String)bindCredential)) {
                bindCredential = SecurityVaultUtil.getValueAsString((String)bindCredential);
            }
            if ((principalDNPrefix = (String)this.options.get(PRINCIPAL_DN_PREFIX_OPT)) == null) {
                principalDNPrefix = "";
            }
            if ((principalDNSuffix = (String)this.options.get(PRINCIPAL_DN_SUFFIX_OPT)) == null) {
                principalDNSuffix = "";
            }
            String matchType = (String)this.options.get(MATCH_ON_USER_DN_OPT);
            boolean matchOnUserDN = Boolean.valueOf(matchType);
            String userDN = String.valueOf(principalDNPrefix) + username + principalDNSuffix;
            env.setProperty("java.naming.provider.url", providerURL);
            env.setProperty("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", credential);
            this.traceLDAPEnv(env);
            InitialContext ctx = null;
            ClassLoader currentTCCL = SecurityActions.getContextClassLoader();
            try {
                String scope;
                String roleAttrName;
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(null);
                }
                ctx = new InitialLdapContext(env, null);
                PicketBoxLogger.LOGGER.traceSuccessfulLogInToLDAP(ctx.toString());
                if (bindDN != null) {
                    PicketBoxLogger.LOGGER.traceRebindWithConfiguredPrincipal(bindDN);
                    env.setProperty("java.naming.security.principal", bindDN);
                    env.put("java.naming.security.credentials", bindCredential);
                    ctx = new InitialLdapContext(env, null);
                }
                String rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
                String userRolesCtxDNAttributeName = (String)this.options.get(USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT);
                if (userRolesCtxDNAttributeName != null) {
                    String[] returnAttribute = new String[]{userRolesCtxDNAttributeName};
                    try {
                        Attributes result = ((InitialDirContext)ctx).getAttributes(userDN, returnAttribute);
                        if (result.get(userRolesCtxDNAttributeName) != null) {
                            rolesCtxDN = result.get(userRolesCtxDNAttributeName).get().toString();
                            PicketBoxLogger.LOGGER.traceFoundUserRolesContextDN(rolesCtxDN);
                        }
                    }
                    catch (NamingException e) {
                        PicketBoxLogger.LOGGER.debugFailureToQueryLDAPAttribute(userRolesCtxDNAttributeName, userDN, (Throwable)e);
                    }
                }
                if (rolesCtxDN == null) break block46;
                String uidAttrName = (String)this.options.get(UID_ATTRIBUTE_ID_OPT);
                if (uidAttrName == null) {
                    uidAttrName = "uid";
                }
                if ((roleAttrName = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT)) == null) {
                    roleAttrName = "roles";
                }
                StringBuffer roleFilter = new StringBuffer("(");
                roleFilter.append(uidAttrName);
                roleFilter.append("={0})");
                String userToMatch = username;
                if (matchOnUserDN) {
                    userToMatch = userDN;
                }
                Object[] roleAttr = new String[]{roleAttrName};
                String roleAttributeIsDNOption = (String)this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
                boolean roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
                String roleNameAttributeID = (String)this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
                if (roleNameAttributeID == null) {
                    roleNameAttributeID = "name";
                }
                int searchScope = 2;
                int searchTimeLimit = 10000;
                String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
                if (timeLimit != null) {
                    try {
                        searchTimeLimit = Integer.parseInt(timeLimit);
                    }
                    catch (NumberFormatException e) {
                        PicketBoxLogger.LOGGER.debugFailureToParseNumberProperty(SEARCH_TIME_LIMIT_OPT, (long)searchTimeLimit);
                    }
                }
                if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)this.options.get(SEARCH_SCOPE_OPT))) {
                    searchScope = 0;
                } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                    searchScope = 1;
                }
                if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                    searchScope = 2;
                }
                NamingEnumeration<SearchResult> answer = null;
                try {
                    try {
                        SearchControls controls = new SearchControls();
                        controls.setSearchScope(searchScope);
                        controls.setReturningAttributes((String[])roleAttr);
                        controls.setTimeLimit(searchTimeLimit);
                        Object[] filterArgs = new Object[]{userToMatch};
                        PicketBoxLogger.LOGGER.traceRolesDNSearch(rolesCtxDN, roleFilter.toString(), userToMatch, Arrays.toString(roleAttr), searchScope, searchTimeLimit);
                        answer = ((InitialDirContext)ctx).search(rolesCtxDN, roleFilter.toString(), filterArgs, controls);
                        while (answer.hasMore()) {
                            SearchResult sr = answer.next();
                            PicketBoxLogger.LOGGER.traceCheckSearchResult(sr.getName());
                            Attributes attrs = sr.getAttributes();
                            Attribute roles = attrs.get(roleAttrName);
                            if (roles != null) {
                                int r = 0;
                                while (r < roles.size()) {
                                    Object value = roles.get(r);
                                    String roleName = null;
                                    if (roleAttributeIsDN) {
                                        String roleDN = value.toString();
                                        String[] returnAttribute = new String[]{roleNameAttributeID};
                                        PicketBoxLogger.LOGGER.traceFollowRoleDN(roleDN);
                                        try {
                                            Attributes result2 = ((InitialDirContext)ctx).getAttributes(roleDN, returnAttribute);
                                            Attribute roles2 = result2.get(roleNameAttributeID);
                                            if (roles2 != null) {
                                                int m = 0;
                                                while (m < roles2.size()) {
                                                    roleName = (String)roles2.get(m);
                                                    this.addRole(roleName);
                                                    ++m;
                                                }
                                            }
                                        }
                                        catch (NamingException e) {
                                            PicketBoxLogger.LOGGER.debugFailureToQueryLDAPAttribute(roleNameAttributeID, roleDN, (Throwable)e);
                                        }
                                    } else {
                                        roleName = value.toString();
                                        this.addRole(roleName);
                                    }
                                    ++r;
                                }
                                continue;
                            }
                            PicketBoxLogger.LOGGER.debugFailureToFindAttrInSearchResult(roleAttrName, sr.getName());
                        }
                    }
                    catch (NamingException e) {
                        PicketBoxLogger.LOGGER.debugFailureToExecuteRolesDNSearch((Throwable)e);
                        if (answer != null) {
                            answer.close();
                        }
                    }
                }
                finally {
                    if (answer != null) {
                        answer.close();
                    }
                }
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(currentTCCL);
                }
            }
        }
    }

    private void addRole(String roleName) {
        if (roleName != null) {
            try {
                Principal p = super.createIdentity(roleName);
                PicketBoxLogger.LOGGER.traceAssignUserToRole(roleName);
                this.userRoles.addMember(p);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(roleName, (Throwable)e);
            }
        }
    }

    private void traceLDAPEnv(Properties env) {
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)env);
        if (tmp.containsKey("java.naming.security.credentials")) {
            tmp.setProperty("java.naming.security.credentials", "******");
        }
        if (tmp.containsKey(BIND_CREDENTIAL)) {
            tmp.setProperty(BIND_CREDENTIAL, "******");
        }
        PicketBoxLogger.LOGGER.traceLDAPConnectionEnv(tmp);
    }
}

