/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.plugins.HostThreadLocal;

public class RemoteHostTrustLoginModule
extends UsernamePasswordLoginModule {
    private static final String OPTION_TRUSTED_HOSTS = "trustedHosts";
    private static final String OPTION_ROLES = "roles";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"trustedHosts", "roles"};
    List<String> trustedHosts;
    private String roleNames;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        String tmp = (String)options.get(OPTION_TRUSTED_HOSTS);
        this.trustedHosts = Arrays.asList(this.parseHosts(tmp));
        this.roleNames = (String)options.get(OPTION_ROLES);
    }

    private String[] parseHosts(String commaDel) {
        return commaDel.split("\\,");
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        String host = this.getRealHost();
        PicketBoxLogger.LOGGER.debugRealHostForTrust(host);
        return this.trustedHosts.contains(host);
    }

    protected String getUsersPassword() throws LoginException {
        return "trustme";
    }

    protected String getRealHost() {
        return HostThreadLocal.get();
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        if (this.roleNames != null) {
            String[] tokens;
            String[] stringArray = tokens = this.roleNames.split(",");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                String roleName = token != null ? token.trim() : token;
                roles.addMember(new SimplePrincipal(roleName));
                ++n2;
            }
        }
        return roleSets;
    }
}

