/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.ClientLoginModule;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.BaseCertLoginModule;
import org.jboss.security.auth.spi.CertRolesLoginModule;
import org.jboss.security.auth.spi.DatabaseCertLoginModule;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;
import org.jboss.security.auth.spi.IdentityLoginModule;
import org.jboss.security.auth.spi.LdapExtLoginModule;
import org.jboss.security.auth.spi.LdapLoginModule;
import org.jboss.security.auth.spi.RoleMappingLoginModule;
import org.jboss.security.auth.spi.RunAsLoginModule;
import org.jboss.security.auth.spi.SimpleServerLoginModule;
import org.jboss.security.auth.spi.UsersRolesLoginModule;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;
import org.picketbox.datasource.security.CallerIdentityLoginModule;
import org.picketbox.datasource.security.ConfiguredIdentityLoginModule;
import org.picketbox.datasource.security.JaasSecurityDomainIdentityLoginModule;
import org.picketbox.datasource.security.PBEIdentityLoginModule;
import org.picketbox.datasource.security.SecureIdentityLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationConfigParser
implements XMLStreamConstants {
    public static Map<String, String> loginModulesMap = new HashMap<String, String>();

    static {
        loginModulesMap.put("Client", ClientLoginModule.class.getName());
        loginModulesMap.put("Certificate", BaseCertLoginModule.class.getName());
        loginModulesMap.put("CertificateRoles", CertRolesLoginModule.class.getName());
        loginModulesMap.put("DatabaseCertificate", DatabaseCertLoginModule.class.getName());
        loginModulesMap.put("Database", DatabaseServerLoginModule.class.getName());
        loginModulesMap.put("Identity", IdentityLoginModule.class.getName());
        loginModulesMap.put("Ldap", LdapLoginModule.class.getName());
        loginModulesMap.put("LdapExtended", LdapExtLoginModule.class.getName());
        loginModulesMap.put("RoleMapping", RoleMappingLoginModule.class.getName());
        loginModulesMap.put("RunAs", RunAsLoginModule.class.getName());
        loginModulesMap.put("Simple", SimpleServerLoginModule.class.getName());
        loginModulesMap.put("UsersRoles", UsersRolesLoginModule.class.getName());
        loginModulesMap.put("CallerIdentity", CallerIdentityLoginModule.class.getName());
        loginModulesMap.put("ConfiguredIdentity", ConfiguredIdentityLoginModule.class.getName());
        loginModulesMap.put("JaasSecurityDomainIdentity", JaasSecurityDomainIdentityLoginModule.class.getName());
        loginModulesMap.put("PBEIdentity", PBEIdentityLoginModule.class.getName());
        loginModulesMap.put("SecureIdentity", SecureIdentityLoginModule.class.getName());
    }

    public Set<AppConfigurationEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        LinkedHashSet<AppConfigurationEntry> entries = new LinkedHashSet<AppConfigurationEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            AppConfigurationEntry entry = null;
            if (!"login-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private AppConfigurationEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        StartElement loginModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = loginModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = this.getControlFlag(attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        return new AppConfigurationEntry(codeName, controlFlag, options);
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        if ("required".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("sufficient".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("optional".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw PicketBoxMessages.MESSAGES.invalidControlFlag(flag);
    }

    public Set<AppConfigurationEntry> parse(XMLStreamReader reader) throws XMLStreamException {
        LinkedHashSet<AppConfigurationEntry> entries = new LinkedHashSet<AppConfigurationEntry>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            AppConfigurationEntry entry = null;
            if (!element.equals((Object)Element.LOGIN_MODULE)) {
                throw StaxParserUtil.unexpectedElement(reader);
            }
            entry = this.getEntry(reader);
            entries.add(entry);
        }
        return entries;
    }

    private AppConfigurationEntry getEntry(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        int count = reader.getAttributeCount();
        if (count < 2) {
            HashSet<Attribute> set = new HashSet<Attribute>();
            set.add(Attribute.CODE);
            set.add(Attribute.FLAG);
            throw StaxParserUtil.missingRequired(reader, set);
        }
        int i = 0;
        while (i < count) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    if (loginModulesMap.containsKey(value)) {
                        codeName = loginModulesMap.get(value);
                        break;
                    }
                    codeName = value;
                    break;
                }
                case FLAG: {
                    controlFlag = this.getControlFlag(value);
                    break;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
            ++i;
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        return new AppConfigurationEntry(codeName, controlFlag, options);
    }
}

