/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingConfigParser
implements XMLStreamConstants {
    private String typeName = MappingType.ROLE.toString();

    public List<MappingModuleEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        ArrayList<MappingModuleEntry> entries = new ArrayList<MappingModuleEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            String peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement);
            MappingModuleEntry entry = null;
            if (!"mapping-module".equals(peekedStartElementName)) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private MappingModuleEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"type".equals(attQName.getLocalPart())) continue;
            this.typeName = attributeValue;
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        return new MappingModuleEntry(codeName, options, this.typeName);
    }

    public List<MappingModuleEntry> parse(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<MappingModuleEntry> entries = new ArrayList<MappingModuleEntry>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            MappingModuleEntry entry = null;
            if (!element.equals((Object)Element.MAPPING_MODULE)) {
                throw StaxParserUtil.unexpectedElement(reader);
            }
            entry = this.getEntry(reader);
            entries.add(entry);
        }
        return entries;
    }

    private MappingModuleEntry getEntry(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        int count = reader.getAttributeCount();
        if (count < 1) {
            throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.CODE));
        }
        int i = 0;
        while (i < count) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    codeName = value;
                    break;
                }
                case TYPE: {
                    this.typeName = value;
                    break;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
            ++i;
        }
        if (codeName == null) {
            throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.CODE));
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        return new MappingModuleEntry(codeName, options, this.typeName);
    }
}

