/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.mapping.providers.role.SecurityActions;

public class Util {
    static Properties loadProperties(String propertiesName) throws IOException {
        URL url;
        Properties bundle;
        block13: {
            bundle = null;
            ClassLoader loader = SecurityActions.getContextClassLoader();
            url = null;
            if (loader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)loader;
                url = SecurityActions.findResource(ucl, propertiesName);
                PicketBoxLogger.LOGGER.traceAttemptToLoadResource(propertiesName);
            }
            if (url == null) {
                url = loader.getResource(propertiesName);
            }
            if (url == null) {
                try {
                    url = new URL(propertiesName);
                }
                catch (MalformedURLException mue) {
                    PicketBoxLogger.LOGGER.debugFailureToOpenPropertiesFromURL((Throwable)mue);
                    File tmp = new File(propertiesName);
                    if (!tmp.exists()) break block13;
                    url = tmp.toURI().toURL();
                }
            }
        }
        if (url == null) {
            throw PicketBoxMessages.MESSAGES.unableToLoadPropertiesFile(propertiesName);
        }
        Properties defaults = new Properties();
        bundle = new Properties(defaults);
        InputStream is = null;
        try {
            is = SecurityActions.openStream(url);
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        if (is != null) {
            try {
                bundle.load(is);
            }
            finally {
                Util.safeClose(is);
            }
        } else {
            throw PicketBoxMessages.MESSAGES.unableToLoadPropertiesFile(propertiesName);
        }
        PicketBoxLogger.LOGGER.tracePropertiesFileLoaded(propertiesName, bundle.keySet());
        return bundle;
    }

    static void addRolesToGroup(String username, RoleGroup roleGroup, Properties roles) {
        String[] roleNames = null;
        if (roles.containsKey(username)) {
            String value = roles.getProperty(username);
            PicketBoxLogger.LOGGER.traceAdditionOfRoleToGroup(value, roleGroup.getRoleName());
            roleNames = Util.parseRoles(value);
        }
        if (roleNames != null) {
            int i = 0;
            while (i < roleNames.length) {
                roleGroup.addRole((Role)new SimpleRole(roleNames[i]));
                ++i;
            }
        }
    }

    static String[] parseRoles(String roles) {
        return roles.split(",");
    }

    static void addRolesToGroup(String username, RoleGroup roleGroup, String dsJndiName, String rolesQuery, boolean suspendResume, TransactionManager tm) {
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        if (suspendResume && tm == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullTransactionManager();
        }
        Transaction tx = null;
        if (suspendResume) {
            try {
                tx = tm.suspend();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(dsJndiName);
                conn = ds.getConnection();
                PicketBoxLogger.LOGGER.traceExecuteQuery(rolesQuery, username);
                ps = conn.prepareStatement(rolesQuery);
                try {
                    ps.setString(1, username);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                rs = ps.executeQuery();
                if (!rs.next()) {
                    PicketBoxLogger.LOGGER.traceQueryWithEmptyResult();
                }
                do {
                    String name = rs.getString(1);
                    roleGroup.addRole((Role)new SimpleRole(name));
                } while (rs.next());
            }
            catch (NamingException ex) {
                throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.failedToLookupDataSourceMessage(dsJndiName), ex);
            }
            catch (SQLException ex) {
                throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.failedToProcessQueryMessage(), ex);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
            if (suspendResume) {
                try {
                    tm.resume(tx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

