/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.acl.Group;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SimplePrincipal;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.picketbox.datasource.security.SubjectActions;

@Deprecated
public class JaasSecurityDomainIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private String username;
    private String password;
    private ObjectName jaasSecurityDomain;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.username = (String)options.get("username");
        if (this.username == null) {
            this.username = (String)options.get("userName");
            if (this.username == null) {
                throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.missingRequiredModuleOptionMessage("username"));
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.missingRequiredModuleOptionMessage("password"));
        }
        String name = (String)options.get("jaasSecurityDomain");
        if (name == null) {
            throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.missingRequiredModuleOptionMessage("jaasSecurityDomain"));
        }
        try {
            this.jaasSecurityDomain = new ObjectName(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        SimplePrincipal principal = new SimplePrincipal(this.username);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.username);
        return true;
    }

    public boolean abort() {
        this.username = null;
        this.password = null;
        return true;
    }

    protected Principal getIdentity() {
        PicketBoxLogger.LOGGER.traceBeginGetIdentity(this.username);
        SimplePrincipal principal = new SimplePrincipal(this.username);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] empty = new Group[]{};
        return empty;
    }

    private static class DecodeAction
    implements PrivilegedExceptionAction {
        String password;
        ObjectName jaasSecurityDomain;
        MBeanServer server;

        DecodeAction(String password, ObjectName jaasSecurityDomain, MBeanServer server) {
            this.password = password;
            this.jaasSecurityDomain = jaasSecurityDomain;
            this.server = server;
        }

        public Object run() throws Exception {
            Object[] args = new Object[]{this.password};
            String[] sig = new String[]{String.class.getName()};
            byte[] secret = (byte[])this.server.invoke(this.jaasSecurityDomain, "decode64", args, sig);
            String secretPassword = new String(secret, "UTF-8");
            return secretPassword.toCharArray();
        }

        static char[] decode(String password, ObjectName jaasSecurityDomain, MBeanServer server) throws Exception {
            DecodeAction action = new DecodeAction(password, jaasSecurityDomain, server);
            try {
                char[] decode = (char[])AccessController.doPrivileged(action);
                return decode;
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }
}

