/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import java.security.Key;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.Base64Utils;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.Util;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.picketbox.datasource.security.SecureIdentityLoginModule;
import org.picketbox.datasource.security.SubjectActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBEIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger(SecureIdentityLoginModule.class);
    private boolean trace = log.isTraceEnabled();
    private String username;
    private String password;
    private char[] pbepass = "jaas is the way".toCharArray();
    private String pbealgo = "PBEwithMD5andDES";
    private byte[] salt = new byte[]{1, 7, 2, 9, 3, 11, 4, 13};
    private int iterationCount = 37;
    private PBEParameterSpec cipherSpec;

    public PBEIdentityLoginModule() {
    }

    PBEIdentityLoginModule(String algo, char[] pass, byte[] pbesalt, int iter) {
        if (pass != null) {
            this.pbepass = pass;
        }
        if (algo != null) {
            this.pbealgo = algo;
        }
        if (pbesalt != null) {
            this.salt = pbesalt;
        }
        if (iter > 0) {
            this.iterationCount = iter;
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.username = (String)options.get("username");
        if (this.username == null) {
            this.username = (String)options.get("userName");
            if (this.username == null) {
                throw new IllegalArgumentException("PB00015: Null Value:The user name is a required option");
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            throw new IllegalArgumentException("PB00015: Null Value:The password is a required option");
        }
        String tmp = (String)options.get("pbepass");
        if (tmp != null) {
            try {
                this.pbepass = Util.loadPassword(tmp);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if ((tmp = (String)options.get("pbealgo")) != null) {
            this.pbealgo = tmp;
        }
        if ((tmp = (String)options.get("salt")) != null) {
            this.salt = tmp.substring(0, 8).getBytes();
        }
        if ((tmp = (String)options.get("iterationCount")) != null) {
            this.iterationCount = Integer.parseInt(tmp);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.trace) {
            log.trace((Object)"login called");
        }
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        SimplePrincipal principal = new SimplePrincipal(this.username);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.username);
        try {
            char[] decodedPassword = this.decode(this.password);
            PasswordCredential cred = new PasswordCredential(this.username, decodedPassword);
            SubjectActions.addCredentials(this.subject, cred);
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Failed to decode password", (Throwable)e);
            }
            throw new LoginException("PB00019: Processing Failed:Failed to decode password: " + e.getMessage());
        }
        return true;
    }

    @Override
    public boolean abort() {
        this.username = null;
        this.password = null;
        return true;
    }

    @Override
    protected Principal getIdentity() {
        if (this.trace) {
            log.trace((Object)("getIdentity called, username=" + this.username));
        }
        SimplePrincipal principal = new SimplePrincipal(this.username);
        return principal;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    private String encode(String secret) throws Exception {
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.pbepass);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbealgo);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance(this.pbealgo);
        cipher.init(1, (Key)cipherKey, this.cipherSpec);
        byte[] encoding = cipher.doFinal(secret.getBytes());
        return Base64Utils.tob64(encoding);
    }

    private char[] decode(String secret) throws Exception {
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.pbepass);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbealgo);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        byte[] encoding = Base64Utils.fromb64(secret);
        Cipher cipher = Cipher.getInstance(this.pbealgo);
        cipher.init(2, (Key)cipherKey, this.cipherSpec);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode).toCharArray();
    }

    public static void main(String[] args) throws Exception {
        String algo = null;
        char[] pass = "jaas is the way".toCharArray();
        byte[] salt = null;
        int iter = -1;
        if (args.length >= 2) {
            pass = args[1].toCharArray();
        }
        if (args.length >= 3) {
            salt = args[2].getBytes();
        }
        if (args.length >= 4) {
            iter = Integer.decode(args[3]);
        }
        if (args.length >= 5) {
            algo = args[4];
        }
        PBEIdentityLoginModule pbe = new PBEIdentityLoginModule(algo, pass, salt, iter);
        String encode = pbe.encode(args[0]);
        System.out.println("Encoded password: " + encode);
    }
}

