/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.MappingProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsRoleMappingProvider
implements MappingProvider<RoleGroup> {
    private static final String REPLACE_ROLES_STRING = "replaceRoles";
    private static final String ROLES_MAP = "rolesMap";
    private MappingResult<RoleGroup> result;
    private Map<String, Object> options = null;
    private Properties roleMapProperties = new Properties();
    private boolean REPLACE_ROLES = false;

    public void init(Map<String, Object> opt) {
        this.options = opt;
        if (this.options != null) {
            if (this.options.containsKey(REPLACE_ROLES_STRING)) {
                this.REPLACE_ROLES = "true".equalsIgnoreCase((String)this.options.get(REPLACE_ROLES_STRING));
            }
            if (this.options.containsKey(ROLES_MAP)) {
                this.roleMapProperties = (Properties)this.options.get(ROLES_MAP);
            }
        }
    }

    public void setMappingResult(MappingResult<RoleGroup> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, RoleGroup mappedObject) {
        ArrayList<Role> removeMembers = new ArrayList<Role>();
        ArrayList<SimpleRole> addMembers = new ArrayList<SimpleRole>();
        List rolesList = mappedObject.getRoles();
        if (rolesList != null) {
            for (Role role : rolesList) {
                String commaSeparatedRoles = this.roleMapProperties.getProperty(role.getRoleName());
                if (commaSeparatedRoles == null) continue;
                String[] tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles);
                int len = tokens != null ? tokens.length : 0;
                for (int i = 0; i < len; ++i) {
                    if (this.REPLACE_ROLES) {
                        removeMembers.add(role);
                    }
                    addMembers.add(new SimpleRole(tokens[i]));
                }
            }
        }
        for (Role role : removeMembers) {
            mappedObject.removeRole(role);
        }
        for (Role role : addMembers) {
            mappedObject.addRole(role);
        }
        this.result.setMappedObject((Object)mappedObject);
    }

    public boolean supports(Class<?> p) {
        return RoleGroup.class.isAssignableFrom(p);
    }
}

