/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.util.state.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.security.util.state.State;
import org.jboss.security.util.state.StateMachine;
import org.jboss.security.util.state.Transition;
import org.jboss.security.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StateMachineParser {
    private static Logger log = Logger.getLogger(StateMachineParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateMachine parse(URL source) throws Exception {
        InputStream in = null;
        Element root = null;
        try {
            in = source.openConnection().getInputStream();
            root = DOMUtils.parse(in);
            Object var5_4 = null;
            this.safeClose(in);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.safeClose(in);
            throw throwable;
        }
        String description = root.getAttribute("description");
        HashMap<String, State> nameToStateMap = new HashMap<String, State>();
        HashMap nameToTransitionsMap = new HashMap();
        HashSet<State> states = new HashSet<State>();
        State startState = null;
        NodeList stateList = root.getChildNodes();
        for (int i = 0; i < stateList.getLength(); ++i) {
            Node stateNode = stateList.item(i);
            if (!stateNode.getNodeName().equals("state")) continue;
            Element stateElement = (Element)stateNode;
            String stateName = stateElement.getAttribute("name");
            State s = new State(stateName);
            states.add(s);
            nameToStateMap.put(stateName, s);
            HashMap<String, String> transitions = new HashMap<String, String>();
            NodeList transitionList = stateElement.getChildNodes();
            for (int j = 0; j < transitionList.getLength(); ++j) {
                Node transitionNode = transitionList.item(j);
                if (!transitionNode.getNodeName().equals("transition")) continue;
                Element transitionElement = (Element)transitionNode;
                String name = transitionElement.getAttribute("name");
                String targetName = transitionElement.getAttribute("target");
                transitions.put(name, targetName);
            }
            nameToTransitionsMap.put(stateName, transitions);
            if (Boolean.valueOf(stateElement.getAttribute("isStartState")) != Boolean.TRUE) continue;
            startState = s;
        }
        Iterator transitions = nameToTransitionsMap.keySet().iterator();
        StringBuffer resolveFailed = new StringBuffer();
        while (transitions.hasNext()) {
            String stateName = (String)transitions.next();
            State s = (State)nameToStateMap.get(stateName);
            HashMap stateTransitions = (HashMap)nameToTransitionsMap.get(stateName);
            for (String name : stateTransitions.keySet()) {
                String targetName = (String)stateTransitions.get(name);
                State target = (State)nameToStateMap.get(targetName);
                if (target == null) {
                    String msg = "Failed to resolve target state: " + targetName + " for transition: " + name;
                    resolveFailed.append(msg);
                    log.debug((Object)msg);
                }
                Transition t = new Transition(name, target);
                s.addTransition(t);
            }
        }
        if (resolveFailed.length() > 0) {
            throw new Exception("PB00019: Processing Failed:Failed to resolve transition targets: " + resolveFailed);
        }
        StateMachine sm = new StateMachine(states, startState, description);
        return sm;
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

