/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi.otp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.otp.SecurityActions;
import org.jboss.security.otp.TimeBasedOTPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossTimeBasedOTPLoginModule
implements LoginModule {
    private static final String PASSWORD_STACKING = "password-stacking";
    private static final String USE_FIRST_PASSWORD = "useFirstPass";
    private static final String NUM_OF_DIGITS_OPT = "numOfDigits";
    private static final String ALGORITHM = "algorithm";
    private static final String ADDITIONAL_ROLES = "additionalRoles";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"password-stacking", "useFirstPass", "numOfDigits", "algorithm", "additionalRoles"};
    public static final String TOTP = "totp";
    private Map<String, Object> lmSharedState = new HashMap<String, Object>();
    private Map<String, Object> lmOptions = new HashMap<String, Object>();
    private CallbackHandler callbackHandler;
    private boolean useFirstPass;
    private int NUMBER_OF_DIGITS = 6;
    private String additionalRoles = null;
    private String algorithm = "HmacSHA1";
    private Subject subject;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String algorithmStr;
        String numDigitString;
        HashSet<String> validOptions = new HashSet<String>(Arrays.asList(ALL_VALID_OPTIONS));
        for (String key : options.keySet()) {
            if (validOptions.contains(key)) continue;
            PicketBoxLogger.LOGGER.warnInvalidModuleOption(key);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.lmSharedState.putAll(sharedState);
        this.lmOptions.putAll(options);
        String passwordStacking = (String)options.get(PASSWORD_STACKING);
        if (passwordStacking != null && passwordStacking.equalsIgnoreCase(USE_FIRST_PASSWORD)) {
            this.useFirstPass = true;
        }
        if ((numDigitString = (String)options.get(NUM_OF_DIGITS_OPT)) != null && numDigitString.length() > 0) {
            this.NUMBER_OF_DIGITS = Integer.parseInt(numDigitString);
        }
        if ((algorithmStr = (String)options.get(ALGORITHM)) != null && !algorithmStr.isEmpty()) {
            if (algorithmStr.equalsIgnoreCase("HmacSHA256")) {
                this.algorithm = "HmacSHA256";
            }
            if (algorithmStr.equalsIgnoreCase("HmacSHA512")) {
                this.algorithm = "HmacSHA512";
            }
        }
        this.additionalRoles = (String)options.get(ADDITIONAL_ROLES);
    }

    @Override
    public boolean login() throws LoginException {
        String username;
        if (this.useFirstPass) {
            username = (String)this.lmSharedState.get("javax.security.auth.login.name");
        } else {
            NameCallback nc = new NameCallback(PicketBoxMessages.MESSAGES.enterUsernameMessage(), "guest");
            Callback[] callbacks = new Callback[]{nc};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                LoginException le = new LoginException();
                le.initCause(e);
                throw le;
            }
            username = nc.getName();
        }
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = null;
        Properties otp = new Properties();
        try {
            is = tcl.getResourceAsStream("otp-users.properties");
            otp.load(is);
        }
        catch (IOException e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        finally {
            this.safeClose(is);
        }
        String seed = otp.getProperty(username);
        String submittedTOTP = this.getTimeBasedOTPFromRequest();
        if (submittedTOTP == null || submittedTOTP.length() == 0) {
            throw new LoginException();
        }
        try {
            boolean result = false;
            if (this.algorithm.equals("HmacSHA1")) {
                result = TimeBasedOTPUtil.validate((String)submittedTOTP, (byte[])seed.getBytes(), (int)this.NUMBER_OF_DIGITS);
            } else if (this.algorithm.equals("HmacSHA256")) {
                result = TimeBasedOTPUtil.validate256((String)submittedTOTP, (byte[])seed.getBytes(), (int)this.NUMBER_OF_DIGITS);
            } else if (this.algorithm.equals("HmacSHA512")) {
                result = TimeBasedOTPUtil.validate512((String)submittedTOTP, (byte[])seed.getBytes(), (int)this.NUMBER_OF_DIGITS);
            }
            if (!result) {
                throw new LoginException();
            }
            Set<Group> groupPrincipals = this.subject.getPrincipals(Group.class);
            if (groupPrincipals != null && groupPrincipals.size() > 0) {
                this.appendRoles(groupPrincipals.iterator().next());
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    private String getTimeBasedOTPFromRequest() {
        String totp = null;
        String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
        try {
            HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
            totp = request.getParameter(TOTP);
        }
        catch (PolicyContextException e) {
            PicketBoxLogger.LOGGER.debugErrorGettingRequestFromPolicyContext((Throwable)e);
        }
        return totp;
    }

    private void appendRoles(Group group) {
        if (!group.getName().equals("Roles")) {
            return;
        }
        if (this.additionalRoles != null && !this.additionalRoles.isEmpty()) {
            StringTokenizer st = new StringTokenizer(this.additionalRoles, ",");
            while (st.hasMoreTokens()) {
                group.addMember((Principal)new SimplePrincipal(st.nextToken().trim()));
            }
        }
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

