/* Generated By:JavaCC: Do not edit this line. SunConfigParser.java */
package org.jboss.security.auth.login;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;

/**
 * A JavaCC 2.1 grammar for the default JAAS configuration file provided by Sun.
 * The format of an entry is:
 Application {
	      ModuleClass  Flag    ModuleOptions;
	      ModuleClass  Flag    ModuleOptions;
	      ModuleClass  Flag    ModuleOptions;
      };

 * @see http://www.webgain.com/products/metamata/java_doc.html
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 16662 $
 */
@SuppressWarnings("all")
public class SunConfigParser implements SunConfigParserConstants {
   private XMLLoginConfigImpl loginConfig;

   public SunConfigParser()
   {
      // keep the parser from feaking out, init using one of
      // the JavaCC generated constructor
      this(new StringReader(""));
   }

   public void parse(Reader configFile, XMLLoginConfigImpl loginConfig)
      throws ParseException
   {
      parse(configFile, loginConfig, false);
   }

   public void parse(Reader configFile, XMLLoginConfigImpl loginConfig, boolean trace)
      throws ParseException
   {
      ReInit(configFile);

      // This will have no effect unless the debugging options are true
      if (trace)
      {
         this.enable_tracing();
      }
      else
      {
         this.disable_tracing();
      }

      this.loginConfig = loginConfig;
      this.config();
   }

   /**
    * Strip off the leading and trailing (quote) chars from the given string
    * and return it.  Does not actually check to make sure they are '\'' chars.
    */
   private String stripQuotes(String image)
   {
      return image.substring(1, image.length() - 1);
   }

   public static void doParse(Reader configFile, XMLLoginConfigImpl loginConfig)
      throws ParseException
   {
      doParse(configFile, loginConfig, false);
   }

   public static void doParse(Reader configFile, XMLLoginConfigImpl loginConfig, boolean trace)
      throws ParseException
   {
      SunConfigParser parser = new SunConfigParser();
      parser.parse(configFile, loginConfig, trace);
   }

/** Start of the grammar */
  final public void config() throws ParseException {
    trace_call("config");
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        appConfig();
      }
      jj_consume_token(0);
    } finally {
      trace_return("config");
    }
  }

  final public void appConfig() throws ParseException {
    trace_call("appConfig");
    try {
   Token t = null;
   String appName;
   AppConfigurationEntry entry;
   ArrayList<AppConfigurationEntry> entries = new ArrayList<AppConfigurationEntry>();
      t = jj_consume_token(IDENTIFIER);
                    appName = t.image;
      jj_consume_token(OPEN_BKT);
      label_2:
      while (true) {
        entry = loginModuleConfig();
         entries.add(entry);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CLASSNAME:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
      }
      jj_consume_token(CLOSE_BKT);
      jj_consume_token(SEMI_COLON);
      AppConfigurationEntry[] appConfig = new AppConfigurationEntry[entries.size()];
      entries.toArray(appConfig);
      loginConfig.addAppConfig(appName, appConfig);
    } finally {
      trace_return("appConfig");
    }
  }

  final public AppConfigurationEntry loginModuleConfig() throws ParseException {
    trace_call("loginModuleConfig");
    try {
   Token t = null;
   String loginModuleClassName;
   HashMap<String, String> optionsMap = new HashMap<String, String>();
   LoginModuleControlFlag controlFlag;
   AppConfigurationEntry entry;
      t = jj_consume_token(CLASSNAME);
                   loginModuleClassName = t.image;
      controlFlag = controlFlag();
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
        case CLASSNAME:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_3;
        }
        moduleOptions(optionsMap);
      }
      jj_consume_token(SEMI_COLON);
         entry = new AppConfigurationEntry(loginModuleClassName, controlFlag, optionsMap);
         {if (true) return entry;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("loginModuleConfig");
    }
  }

  final public LoginModuleControlFlag controlFlag() throws ParseException {
    trace_call("controlFlag");
    try {
   Token t;
   LoginModuleControlFlag flag = null;
      t = jj_consume_token(CONTROL_FLAG);
      if( LoginModuleControlFlag.REQUIRED.toString().indexOf(t.image) > 0 )
         flag = LoginModuleControlFlag.REQUIRED;
      else if( LoginModuleControlFlag.REQUISITE.toString().indexOf(t.image) > 0 )
         flag = LoginModuleControlFlag.REQUISITE;
      else if( LoginModuleControlFlag.SUFFICIENT.toString().indexOf(t.image) > 0 )
         flag = LoginModuleControlFlag.SUFFICIENT;
      else if( LoginModuleControlFlag.OPTIONAL.toString().indexOf(t.image) > 0 )
         flag = LoginModuleControlFlag.OPTIONAL;
      {if (true) return flag;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("controlFlag");
    }
  }

  final public void moduleOptions(HashMap<String, String> optionsMap) throws ParseException {
    trace_call("moduleOptions");
    try {
   Token t;
   String name, value;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
        break;
      case CLASSNAME:
        t = jj_consume_token(CLASSNAME);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
     name = t.image;
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LONG:
      case DOUBLE:
      case IDENTIFIER:
      case CLASSNAME:
      case ANY:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          t = jj_consume_token(IDENTIFIER);
          break;
        case CLASSNAME:
          t = jj_consume_token(CLASSNAME);
          break;
        case DOUBLE:
          t = jj_consume_token(DOUBLE);
          break;
        case LONG:
          t = jj_consume_token(LONG);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
         value = t.image;
         optionsMap.put(name, value);
        break;
      case STRING:
        t = jj_consume_token(STRING);
         value = stripQuotes(t.image);
         optionsMap.put(name, value);
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("moduleOptions");
    }
  }

  /** Generated Token Manager. */
  public SunConfigParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[6];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x10000,0x20000,0x30000,0x30000,0x131800,0x135800,};
   }

  /** Constructor with InputStream. */
  public SunConfigParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SunConfigParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SunConfigParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public SunConfigParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SunConfigParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public SunConfigParser(SunConfigParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(SunConfigParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      trace_token(token, "");
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
      trace_token(token, " (in getNextToken)");
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[22];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 6; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 22; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled = true;

/** Enable tracing. */
  final public void enable_tracing() {
    trace_enabled = true;
  }

/** Disable tracing. */
  final public void disable_tracing() {
    trace_enabled = false;
  }

  private void trace_call(String s) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Call:   " + s);
    }
    trace_indent = trace_indent + 2;
  }

  private void trace_return(String s) {
    trace_indent = trace_indent - 2;
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Return: " + s);
    }
  }

  private void trace_token(Token t, String where) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Consumed token: <" + tokenImage[t.kind]);
      if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
        System.out.print(": \"" + t.image + "\"");
      }
      System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
    }
  }

  private void trace_scan(Token t1, int t2) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Visited token: <" + tokenImage[t1.kind]);
      if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
        System.out.print(": \"" + t1.image + "\"");
      }
      System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
    }
  }

}
