/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.Element;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityTrustInfo
extends BaseSecurityInfo<IdentityTrustModuleEntry> {
    public IdentityTrustInfo(String name) {
        super(name);
    }

    public IdentityTrustModuleEntry[] getIdentityTrustModuleEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        IdentityTrustModuleEntry[] entries = new IdentityTrustModuleEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }

    @Override
    protected BaseSecurityInfo<IdentityTrustModuleEntry> create(String name) {
        return new IdentityTrustInfo(name);
    }

    public void writeContent(XMLStreamWriter writer) throws XMLStreamException {
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            IdentityTrustModuleEntry entry = (IdentityTrustModuleEntry)this.moduleEntries.get(i);
            writer.writeStartElement(Element.TRUST_MODULE.getLocalName());
            writer.writeAttribute(Attribute.CODE.getLocalName(), entry.getName());
            writer.writeAttribute(Attribute.FLAG.getLocalName(), entry.getControlFlag().toString().toLowerCase(Locale.ENGLISH));
            Map<String, Object> options = entry.getOptions();
            if (options != null && options.size() > 0) {
                for (Map.Entry<String, Object> option : options.entrySet()) {
                    writer.writeStartElement(Element.MODULE_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), option.getKey());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), option.getValue().toString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

