/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.security.NestableGroup;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.SecurityActions;

public abstract class AbstractServerLoginModule
implements LoginModule {
    private static final String PASSWORD_STACKING = "password-stacking";
    private static final String USE_FIRST_PASSWORD = "useFirstPass";
    private static final String PRINCIPAL_CLASS = "principalClass";
    private static final String UNAUTHENTICATED_IDENTITY = "unauthenticatedIdentity";
    private static final String MODULE = "module";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"password-stacking", "principalClass", "unauthenticatedIdentity", "module", "jboss.security.security_domain"};
    private HashSet<String> validOptions;
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    protected boolean useFirstPass;
    protected boolean loginOk;
    protected String principalClassName;
    protected Principal unauthenticatedIdentity;
    protected String jbossModuleName;
    protected Logger log = Logger.getLogger(AbstractServerLoginModule.class);

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String passwordStacking;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        PicketBoxLogger.LOGGER.traceBeginInitialize();
        if (this.validOptions != null) {
            this.addValidOptions(ALL_VALID_OPTIONS);
            this.checkOptions();
        }
        if ((passwordStacking = (String)options.get(PASSWORD_STACKING)) != null && passwordStacking.equalsIgnoreCase(USE_FIRST_PASSWORD)) {
            this.useFirstPass = true;
        }
        this.principalClassName = (String)options.get(PRINCIPAL_CLASS);
        String name = (String)options.get(UNAUTHENTICATED_IDENTITY);
        if (name != null) {
            try {
                this.unauthenticatedIdentity = this.createIdentity(name);
                PicketBoxLogger.LOGGER.traceUnauthenticatedIdentity(name);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.warnFailureToCreateUnauthIdentity((Throwable)e);
            }
        }
        this.jbossModuleName = (String)options.get(MODULE);
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        this.loginOk = false;
        if (this.useFirstPass) {
            try {
                Object identity = this.sharedState.get("javax.security.auth.login.name");
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                if (identity != null && credential != null) {
                    this.loginOk = true;
                    return true;
                }
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailedLogin((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginCommit(this.loginOk);
        if (!this.loginOk) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        Principal identity = this.getIdentity();
        principals.add(identity);
        Group[] roleSets = this.getRoleSets();
        for (int g = 0; g < roleSets.length; ++g) {
            Group group = roleSets[g];
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            if (subjectGroup instanceof NestableGroup) {
                SimpleGroup tmp = new SimpleGroup("Roles");
                subjectGroup.addMember((Principal)tmp);
                subjectGroup = tmp;
            }
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        Group callerGroup = this.getCallerPrincipalGroup(principals);
        if (callerGroup == null) {
            callerGroup = new SimpleGroup("CallerPrincipal");
            callerGroup.addMember(identity);
            principals.add((Principal)callerGroup);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginAbort(this.loginOk);
        return this.loginOk;
    }

    @Override
    public boolean logout() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogout();
        Principal identity = this.getIdentity();
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(identity);
        Group callerGroup = this.getCallerPrincipalGroup(principals);
        if (callerGroup != null) {
            principals.remove(callerGroup);
        }
        return true;
    }

    protected abstract Principal getIdentity();

    protected abstract Group[] getRoleSets() throws LoginException;

    protected boolean getUseFirstPass() {
        return this.useFirstPass;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Group createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal next : principals) {
            Group grp;
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add(roles);
        }
        return roles;
    }

    protected Principal createIdentity(String username) throws Exception {
        Principal p = null;
        if (this.principalClassName == null) {
            p = new SimplePrincipal(username);
        } else {
            ClassLoader loader = SecurityActions.getContextClassLoader();
            Class<?> clazz = loader.loadClass(this.principalClassName);
            Class[] ctorSig = new Class[]{String.class};
            Constructor<?> ctor = clazz.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{username};
            p = (Principal)ctor.newInstance(ctorArgs);
        }
        return p;
    }

    protected Group getCallerPrincipalGroup(Set<Principal> principals) {
        Group callerGroup = null;
        for (Principal principal : principals) {
            Group group;
            if (!(principal instanceof Group) || !(group = (Group)Group.class.cast(principal)).getName().equals("CallerPrincipal")) continue;
            callerGroup = group;
            break;
        }
        return callerGroup;
    }

    protected void addValidOptions(String[] moduleValidOptions) {
        if (this.validOptions == null) {
            this.validOptions = new HashSet(moduleValidOptions.length);
        }
        this.validOptions.addAll(Arrays.asList(moduleValidOptions));
    }

    protected void checkOptions() {
        for (Object key : this.options.keySet()) {
            if (this.validOptions.contains(key)) continue;
            PicketBoxLogger.LOGGER.warnInvalidModuleOption((String)key);
        }
    }
}

