/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.AuthPermission;

public abstract class BaseSecurityInfo<T> {
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    protected String name;
    protected ArrayList<T> moduleEntries = new ArrayList();
    protected Set<String> jbossModuleNames = new HashSet<String>();

    public BaseSecurityInfo() {
    }

    public BaseSecurityInfo(String name) {
        this.name = name;
    }

    public void add(T ame) {
        this.moduleEntries.add(ame);
    }

    public void add(List<? extends T> moduleEntries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.moduleEntries.addAll(moduleEntries);
    }

    public List<T> getModuleEntries() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        return this.moduleEntries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getJBossModuleNames() {
        return this.jbossModuleNames;
    }

    public void addJBossModuleName(String jbossModuleName) {
        if (jbossModuleName != null && !jbossModuleName.isEmpty()) {
            this.jbossModuleNames.add(jbossModuleName);
        }
    }

    protected abstract BaseSecurityInfo<T> create(String var1);

    public BaseSecurityInfo<T> merge(BaseSecurityInfo<T> bi) {
        if (bi == null) {
            return this;
        }
        ArrayList<T> al = new ArrayList<T>();
        al.addAll(bi.getModuleEntries());
        al.addAll(this.moduleEntries);
        BaseSecurityInfo mergedBAI = this.create(this.name);
        mergedBAI.add((List<? extends T>)al);
        return mergedBAI;
    }
}

