/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public abstract class AbstractJACCModuleDelegate
extends AuthorizationModuleDelegate {
    @Override
    public abstract int authorize(Resource var1, Subject var2, RoleGroup var3);

    protected Principal[] getPrincipals(Subject subject, Role role) {
        Set<Principal> principalsSet = null;
        if (role != null) {
            principalsSet = this.getPrincipalSetFromRole(role);
        }
        Principal[] arr = null;
        if (principalsSet != null) {
            arr = new Principal[principalsSet.size()];
            principalsSet.toArray(arr);
        }
        return arr;
    }

    private Set<Principal> getPrincipalSetFromRole(Role role) {
        HashSet<Principal> principalsSet = new HashSet<Principal>();
        if (role instanceof RoleGroup) {
            RoleGroup rg = (RoleGroup)role;
            Collection rolesList = rg.getRoles();
            for (Role r : rolesList) {
                principalsSet.add(new SimplePrincipal(r.getRoleName()));
            }
        } else {
            principalsSet.add(new SimplePrincipal(role.getRoleName()));
        }
        return principalsSet;
    }
}

