/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.SubjectActions;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.util.MBeanServerLocator;

public abstract class AbstractPasswordCredentialLoginModule
extends AbstractServerLoginModule {
    private static final Logger log = Logger.getLogger(AbstractPasswordCredentialLoginModule.class);
    private MBeanServer server;
    private ObjectName managedConnectionFactoryName;
    private ManagedConnectionFactory mcf;
    private Boolean ignoreMissigingMCF;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        String name = (String)options.get("managedConnectionFactoryName");
        try {
            this.managedConnectionFactoryName = new ObjectName(name);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Malformed ObjectName: " + name);
        }
        if (this.managedConnectionFactoryName == null) {
            throw new IllegalArgumentException("Must supply a managedConnectionFactoryName!");
        }
        Object flag = options.get("ignoreMissigingMCF");
        if (flag instanceof Boolean) {
            this.ignoreMissigingMCF = (Boolean)flag;
        } else if (flag != null) {
            this.ignoreMissigingMCF = Boolean.valueOf(flag.toString());
        }
        this.server = MBeanServerLocator.locateJBoss();
        this.getMcf();
    }

    public boolean login() throws LoginException {
        if (this.mcf == null) {
            return false;
        }
        return super.login();
    }

    public boolean logout() throws LoginException {
        this.removeCredentials();
        return super.logout();
    }

    protected ManagedConnectionFactory getMcf() {
        if (this.mcf == null) {
            block4: {
                try {
                    this.mcf = (ManagedConnectionFactory)this.server.getAttribute(this.managedConnectionFactoryName, "ManagedConnectionFactory");
                }
                catch (Exception e) {
                    log.error((Object)("The ConnectionManager mbean: " + this.managedConnectionFactoryName + " specified in a ConfiguredIdentityLoginModule could not be found." + " ConnectionFactory will be unusable!"), (Throwable)e);
                    if (Boolean.TRUE == this.ignoreMissigingMCF) break block4;
                    throw new IllegalArgumentException("Managed Connection Factory not found: " + this.managedConnectionFactoryName);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("mcfname: " + this.managedConnectionFactoryName));
            }
        }
        return this.mcf;
    }

    protected MBeanServer getServer() {
        return this.server;
    }

    protected void removeCredentials() {
        this.sharedState.remove("javax.security.auth.login.name");
        this.sharedState.remove("javax.security.auth.login.password");
        SubjectActions.removeCredentials(this.subject, this.mcf);
    }
}

