/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltClientLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private boolean useFirstPass;
    private String username;
    private char[] password = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String passwordStacking;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        PicketBoxLogger.LOGGER.debugModuleOption("jboss.security.security_domain", options.get("jboss.security.security_domain"));
        String mt = (String)options.get("multi-threaded");
        if (Boolean.valueOf(mt).booleanValue()) {
            PicketBoxLogger.LOGGER.debugModuleOption("multi-threaded", (Object)mt);
        }
        this.useFirstPass = (passwordStacking = (String)options.get("password-stacking")) != null;
        PicketBoxLogger.LOGGER.debugModuleOption("password-stacking", (Object)passwordStacking);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.useFirstPass) {
            return true;
        }
        if (this.callbackHandler == null) {
            throw PicketBoxMessages.MESSAGES.noCallbackHandlerAvailable();
        }
        PasswordCallback pc = new PasswordCallback(PicketBoxMessages.MESSAGES.enterPasswordMessage(), false);
        NameCallback nc = new NameCallback(PicketBoxMessages.MESSAGES.enterUsernameMessage(), "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                pc.clearPassword();
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException(uce.getLocalizedMessage());
            le.initCause(uce);
            throw le;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        Principal p = null;
        Object credential = this.password;
        if (this.useFirstPass) {
            Object user = this.sharedState.get("javax.security.auth.login.name");
            if (!(user instanceof Principal)) {
                this.username = user != null ? user.toString() : "";
                p = new SimplePrincipal(this.username);
            } else {
                p = (Principal)user;
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
        } else {
            p = new SimplePrincipal(this.username);
        }
        if (!principals.isEmpty()) {
            p = principals.iterator().next();
        }
        SecurityAssociationActions.setPrincipalInfo(p, credential, this.subject);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        int length = this.password != null ? this.password.length : 0;
        for (int n = 0; n < length; ++n) {
            this.password[n] = '\u0000';
        }
        SecurityAssociationActions.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        SecurityAssociationActions.clear();
        return true;
    }
}

