/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name, String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        String prop = sm != null ? SystemPropertyAction.PRIVILEGED.getProperty(name, defaultValue) : SystemPropertyAction.NON_PRIVILEGED.getProperty(name, defaultValue);
        return prop;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTCLAction
    implements PrivilegedAction<ClassLoader> {
        static PrivilegedAction<ClassLoader> ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    static interface SystemPropertyAction {
        public static final SystemPropertyAction PRIVILEGED = new SystemPropertyAction(){

            public String getProperty(final String name, final String defaultValue) {
                String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String p = System.getProperty(name, defaultValue);
                        return p;
                    }
                });
                return prop;
            }
        };
        public static final SystemPropertyAction NON_PRIVILEGED = new SystemPropertyAction(){

            public String getProperty(String name, String defaultValue) {
                String prop = System.getProperty(name, defaultValue);
                return prop;
            }
        };

        public String getProperty(String var1, String var2);
    }
}

