/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.PicketBoxMessages;

public class ConsoleInputHandler
implements CallbackHandler {
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            BufferedReader br;
            InputStreamReader isr;
            String prompt;
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                prompt = nc.getPrompt();
                if (prompt == null) {
                    prompt = PicketBoxMessages.MESSAGES.enterUsernameMessage();
                }
                System.out.print(prompt);
                isr = new InputStreamReader(System.in);
                br = new BufferedReader(isr);
                try {
                    String username = br.readLine();
                    nc.setName(username);
                    continue;
                }
                catch (IOException e) {
                    throw PicketBoxMessages.MESSAGES.failedToObtainUsername((Throwable)e);
                }
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                prompt = pc.getPrompt();
                if (prompt == null) {
                    prompt = PicketBoxMessages.MESSAGES.enterPasswordMessage();
                }
                System.out.print(prompt);
                isr = new InputStreamReader(System.in);
                br = new BufferedReader(isr);
                try {
                    String password = br.readLine();
                    pc.setPassword(password.toCharArray());
                    continue;
                }
                catch (IOException e) {
                    throw PicketBoxMessages.MESSAGES.failedToObtainPassword((Throwable)e);
                }
            }
            throw PicketBoxMessages.MESSAGES.unableToHandleCallback(c, this.getClass().getName(), c.getClass().getCanonicalName());
        }
    }
}

