/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.deltaspike;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.deltaspike.security.api.User;
import org.apache.deltaspike.security.api.authentication.AuthenticationException;
import org.apache.deltaspike.security.api.credential.LoginCredential;
import org.apache.deltaspike.security.impl.authentication.DefaultIdentity;
import org.picketbox.core.Credential;
import org.picketbox.core.PicketBoxManager;
import org.picketbox.core.PicketBoxSubject;
import org.picketbox.deltaspike.PicketBoxUser;

@SessionScoped
@Named(value="identity")
public class PicketBoxIdentity
extends DefaultIdentity {
    private static final long serialVersionUID = -290838764498141080L;
    @Inject
    private LoginCredential credential;
    @Inject
    private PicketBoxManager picketBoxManager;
    private PicketBoxUser user;

    public boolean authenticate() {
        PicketBoxSubject subject = null;
        try {
            PicketBoxSubject authenticationSubject = new PicketBoxSubject();
            authenticationSubject.setCredential((Credential)this.credential.getCredential().getValue());
            subject = this.picketBoxManager.authenticate(authenticationSubject);
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
        if (subject != null && subject.isAuthenticated()) {
            this.createUser(subject);
            return true;
        }
        return false;
    }

    public void logout() {
        if (this.isLoggedIn()) {
            super.logout();
            this.picketBoxManager.logout(this.user.getSubject());
            this.user = null;
        }
    }

    private void createUser(PicketBoxSubject subject) {
        this.user = new PicketBoxUser(subject);
    }

    public boolean isLoggedIn() {
        return this.user != null && this.user.getSubject().isAuthenticated();
    }

    public User getUser() {
        return this.user;
    }
}

