/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.deltaspike.authorization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.security.api.Identity;
import org.apache.deltaspike.security.api.authorization.annotation.Secures;
import org.picketbox.core.PicketBoxSubject;
import org.picketbox.deltaspike.PicketBoxUser;
import org.picketbox.deltaspike.authorization.RestrictedRoles;
import org.picketbox.deltaspike.authorization.UserLoggedIn;

@ApplicationScoped
public class AuthorizationManager {
    @Secures
    @RestrictedRoles
    public boolean restrictRoles(InvocationContext ctx, Identity identity) {
        String[] restrictedRoles;
        if (!identity.isLoggedIn()) {
            return false;
        }
        PicketBoxUser user = (PicketBoxUser)identity.getUser();
        PicketBoxSubject subject = user.getSubject();
        for (String restrictedRole : restrictedRoles = this.getRestrictedRoles(ctx)) {
            if (!subject.hasRole(restrictedRole)) continue;
            return true;
        }
        return false;
    }

    @Secures
    @UserLoggedIn
    public boolean isUserLoggedIn(InvocationContext ctx, Identity identity) {
        return identity.isLoggedIn();
    }

    private String[] getRestrictedRoles(InvocationContext ctx) {
        RestrictedRoles restrictedRolesAnnotation = (RestrictedRoles)this.getDeclaredAnnotation(RestrictedRoles.class, ctx);
        if (restrictedRolesAnnotation != null) {
            return restrictedRolesAnnotation.value();
        }
        return new String[0];
    }

    private Annotation getDeclaredAnnotation(Class<? extends Annotation> annotationClass, InvocationContext ctx) {
        Method method = ctx.getMethod();
        Class<?> type = method.getDeclaringClass();
        if (method.isAnnotationPresent(RestrictedRoles.class)) {
            return method.getAnnotation(RestrictedRoles.class);
        }
        if (type.isAnnotationPresent(RestrictedRoles.class)) {
            return type.getAnnotation(RestrictedRoles.class);
        }
        return null;
    }
}

